/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.LabelParser;
import org.opendaylight.protocol.pcep.spi.LabelSerializer;
import org.opendaylight.protocol.pcep.spi.LabelUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.LabelType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.WavebandSwitchingLabelCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.WavebandSwitchingLabelCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabel;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.label.subobject.label.type.waveband.switching.label._case.WavebandSwitchingLabelBuilder;

public class WavebandSwitchingLabelParser
implements LabelParser,
LabelSerializer {
    public static final int CTYPE = 3;
    private static final int WAVEB_F_LENGTH = 4;
    private static final int START_F_LENGTH = 4;
    private static final int END_F_LENGTH = 4;
    private static final int CONTENT_LENGTH = 12;

    public LabelType parseLabel(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 12) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 12 + ".");
        }
        WavebandSwitchingLabelBuilder builder = new WavebandSwitchingLabelBuilder();
        builder.setWavebandId(Long.valueOf(buffer.readUnsignedInt()));
        builder.setStartLabel(Long.valueOf(buffer.readUnsignedInt()));
        builder.setEndLabel(Long.valueOf(buffer.readUnsignedInt()));
        return new WavebandSwitchingLabelCaseBuilder().setWavebandSwitchingLabel(builder.build()).build();
    }

    public void serializeLabel(boolean unidirectional, boolean global, LabelType subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject instanceof WavebandSwitchingLabelCase), (String)"Unknown Label Subobject instance. Passed {}. Needed WavebandSwitchingLabelCase.", subobject.getClass());
        WavebandSwitchingLabel obj = ((WavebandSwitchingLabelCase)subobject).getWavebandSwitchingLabel();
        ByteBuf body = Unpooled.buffer((int)12);
        Preconditions.checkArgument((obj.getWavebandId() != null ? 1 : 0) != 0, (Object)"WavebandId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)obj.getWavebandId(), (ByteBuf)body);
        Preconditions.checkArgument((obj.getStartLabel() != null ? 1 : 0) != 0, (Object)"StartLabel is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)obj.getStartLabel(), (ByteBuf)body);
        Preconditions.checkArgument((obj.getEndLabel() != null ? 1 : 0) != 0, (Object)"EndLabel is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)obj.getEndLabel(), (ByteBuf)body);
        LabelUtil.formatLabel((int)3, (Boolean)unidirectional, (Boolean)global, (ByteBuf)body, (ByteBuf)buffer);
    }
}

