/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.XROSubobjectUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SrlgId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.SrlgCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.SrlgCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case.Srlg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case.SrlgBuilder;

public class XROSRLGSubobjectParser
implements XROSubobjectParser,
XROSubobjectSerializer {
    public static final int TYPE = 34;
    private static final int CONTENT_LENGTH = 6;

    public Subobject parseSubobject(ByteBuf buffer, boolean mandatory) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: " + 6 + ".");
        }
        SubobjectBuilder builder = new SubobjectBuilder();
        builder.setMandatory(Boolean.valueOf(mandatory));
        builder.setSubobjectType((SubobjectType)new SrlgCaseBuilder().setSrlg(new SrlgBuilder().setSrlgId(new SrlgId(Long.valueOf(buffer.readUnsignedInt()))).build()).build());
        buffer.readByte();
        builder.setAttribute(ExcludeRouteSubobjects.Attribute.forValue((int)buffer.readUnsignedByte()));
        return builder.build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof SrlgCase), (String)"Unknown subobject instance. Passed %s. Needed SrlgCase.", subobject.getSubobjectType().getClass());
        Srlg specObj = ((SrlgCase)subobject.getSubobjectType()).getSrlg();
        ByteBuf body = Unpooled.buffer((int)6);
        Preconditions.checkArgument((specObj.getSrlgId() != null ? 1 : 0) != 0, (Object)"SrlgId is mandatory.");
        ByteBufWriteUtil.writeUnsignedInt((Long)specObj.getSrlgId().getValue(), (ByteBuf)body);
        Preconditions.checkArgument((subobject.getAttribute() != null ? 1 : 0) != 0, (Object)"Attribute is mandatory.");
        ByteBufWriteUtil.writeUnsignedByte(null, (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedByte((Short)((short)subobject.getAttribute().getIntValue()), (ByteBuf)body);
        XROSubobjectUtil.formatSubobject((int)34, (Boolean)subobject.isMandatory(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

