/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.OrderBuilder;

public class OrderTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 5;

    public Order parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new OrderBuilder().setDelete(Long.valueOf(buffer.readUnsignedInt())).setSetup(Long.valueOf(buffer.readUnsignedInt())).build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof Order), (Object)"OrderTlv is mandatory.");
        Order otlv = (Order)tlv;
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeUnsignedInt((Long)otlv.getDelete(), (ByteBuf)body);
        ByteBufWriteUtil.writeUnsignedInt((Long)otlv.getSetup(), (ByteBuf)body);
        TlvUtil.formatTlv((int)5, (ByteBuf)body, (ByteBuf)buffer);
    }
}

