/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.HashSet;
import java.util.Set;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupTypeBuilder;

public class PathSetupTypeTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 28;
    private static final int CONTENT_LENGTH = 4;
    private static final int PST_LENGTH = 1;
    private static final int OFFSET = 3;
    private static final short RSVP_TE_PST = 0;
    private static final String UNSUPPORTED_PST = "Unsupported path setup type.";
    private static final Set<Short> PSTS = new HashSet<Short>();

    public PathSetupTypeTlvParser() {
        PSTS.add((short)0);
    }

    public PathSetupTypeTlvParser(short srTePst) {
        this();
        PSTS.add(srTePst);
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof PathSetupType), (Object)"PathSetupType is mandatory.");
        PathSetupType pstTlv = (PathSetupType)tlv;
        Preconditions.checkArgument((boolean)PathSetupTypeTlvParser.checkPST(pstTlv.getPst()), (Object)UNSUPPORTED_PST);
        ByteBuf body = Unpooled.buffer((int)4);
        body.writeZero(3);
        ByteBufWriteUtil.writeUnsignedByte((Short)pstTlv.getPst(), (ByteBuf)body);
        TlvUtil.formatTlv((int)28, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Tlv parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        short pst = buffer.readerIndex(3).readUnsignedByte();
        if (!PathSetupTypeTlvParser.checkPST(pst)) {
            throw new PCEPDeserializerException(UNSUPPORTED_PST);
        }
        return new PathSetupTypeBuilder().setPst(Short.valueOf(pst)).build();
    }

    private static boolean checkPST(Short pst) {
        return pst != null && PSTS.contains(pst);
    }
}

