/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.KeepaliveBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.KeepaliveMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.keepalive.message.KeepaliveMessageBuilder;

public class PCEPKeepAliveMessageParser
extends AbstractMessageParser {
    private static final KeepaliveMessage MESSAGE = new KeepaliveBuilder().setKeepaliveMessage(new KeepaliveMessageBuilder().build()).build();
    public static final int TYPE = 2;

    public PCEPKeepAliveMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof KeepaliveMessage), (String)"Wrong instance of Message. Passed instance of %s. Need KeepaliveMessage.", message.getClass());
        MessageUtil.formatMessage((int)2, (ByteBuf)Unpooled.EMPTY_BUFFER, (ByteBuf)out);
    }

    protected KeepaliveMessage validate(List<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        if (objects != null && !objects.isEmpty()) {
            throw new PCEPDeserializerException("Keepalive message should not contain any objects.");
        }
        return MESSAGE;
    }
}

