/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.BranchNodeType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type.BranchNodeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type.BranchNodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type.NonBranchNodeCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bnc.object.branch.node.type.NonBranchNodeCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.branch.node.object.BranchNodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.RequestsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.SvecBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.monitoring.request.PceIdList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.monitoring.request.PceIdListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.PathKeyExpansionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputation;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.SegmentComputationBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2mpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2p;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.P2pBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPair;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.EndpointRroPairBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.IroBncChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.MetricBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.RrosBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.RouteObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.ReportedRouteObjectCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.ReportedRouteObjectCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.SecondaryReportedRouteObjectCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.endpoint.rro.pair.rros.route.object.SecondaryReportedRouteObjectCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.iro.bnc.choice.BncCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.iro.bnc.choice.BncCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.iro.bnc.choice.IroCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.iro.bnc.choice.IroCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2p.ReportedRoute;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.svec.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.reported.route.object.Srro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;

public class PCEPRequestMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 3;

    public PCEPRequestMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcreq), (String)"Wrong instance of Message. Passed instance of %s. Need Pcreq.", message.getClass());
        PcreqMessage msg = ((Pcreq)message).getPcreqMessage();
        Preconditions.checkArgument((msg.getRequests() != null && !msg.getRequests().isEmpty() ? 1 : 0) != 0, (Object)"Requests cannot be null or empty.");
        ByteBuf buffer = Unpooled.buffer();
        if (msg.getMonitoringRequest() != null) {
            this.serializeMonitoringRequest(msg.getMonitoringRequest(), buffer);
        }
        if (msg.getSvec() != null) {
            this.serializeSvec(msg, buffer);
        }
        this.serializeRequest(msg, buffer);
        MessageUtil.formatMessage((int)3, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected void serializeRequest(PcreqMessage msg, ByteBuf buffer) {
        for (Requests req : msg.getRequests()) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)req.getRp(), buffer);
            this.serializeVendorInformationObjects(req.getVendorInformationObject(), buffer);
            if (req.getPathKeyExpansion() != null) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)req.getPathKeyExpansion().getPathKey(), buffer);
            }
            if (req.getSegmentComputation() == null) continue;
            SegmentComputation sc = req.getSegmentComputation();
            if (sc.getP2p() != null) {
                this.serializeP2P(buffer, sc.getP2p());
            }
            if (sc.getP2mp() == null) continue;
            this.serializeP2MP(buffer, sc.getP2mp());
        }
    }

    protected void serializeSvec(PcreqMessage msg, ByteBuf buffer) {
        for (Svec s : msg.getSvec()) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)s.getSvec(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)s.getOf(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)s.getGc(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)s.getXro(), buffer);
            if (s.getMetric() != null) {
                for (Metric m : s.getMetric()) {
                    this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)m.getMetric(), buffer);
                }
            }
            this.serializeVendorInformationObjects(s.getVendorInformationObject(), buffer);
        }
    }

    protected void serializeP2P(ByteBuf buffer, P2p p2p) {
        ReportedRoute rr;
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getEndpointsObj(), buffer);
        this.serializeVendorInformationObjects(p2p.getVendorInformationObject(), buffer);
        if (p2p.getReportedRoute() != null && (rr = p2p.getReportedRoute()) != null) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)rr.getRro(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)rr.getReoptimizationBandwidth(), buffer);
        }
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getLoadBalancing(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getLspa(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getBandwidth(), buffer);
        if (p2p.getMetrics() != null) {
            for (Metrics m : p2p.getMetrics()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)m.getMetric(), buffer);
            }
        }
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getIro(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getRro(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getXro(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getOf(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2p.getClassType(), buffer);
    }

    protected void serializeP2MP(ByteBuf buffer, P2mp p2mp) {
        List endpointRroPairList = p2mp.getEndpointRroPair();
        if (endpointRroPairList == null || endpointRroPairList.isEmpty()) {
            throw new IllegalStateException("At least one instance of Endpoint must be present in P2MP Request!");
        }
        endpointRroPairList.forEach(pair -> {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pair.getEndpointsObj(), buffer);
            pair.getRros().forEach(rro -> {
                if (rro.getRouteObject() instanceof ReportedRouteObjectCase) {
                    this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((ReportedRouteObjectCase)rro.getRouteObject()).getRro(), buffer);
                } else if (rro.getRouteObject() instanceof SecondaryReportedRouteObjectCase) {
                    this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((SecondaryReportedRouteObjectCase)rro.getRouteObject()).getSrro(), buffer);
                }
            });
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pair.getReoptimizationBandwidth(), buffer);
        });
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2mp.getOf(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2mp.getLspa(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2mp.getBandwidth(), buffer);
        if (p2mp.getMetric() != null) {
            for (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric m : p2mp.getMetric()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)m.getMetric(), buffer);
            }
        }
        if (p2mp.getIroBncChoice() instanceof IroCase) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((IroCase)p2mp.getIroBncChoice()).getIro(), buffer);
        } else if (p2mp.getIroBncChoice() instanceof BncCase) {
            BranchNodeType branchNodeType = ((BncCase)p2mp.getIroBncChoice()).getBranchNodeType();
            if (branchNodeType instanceof BranchNodeCase) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((BranchNodeCase)branchNodeType).getBranchNodeList(), buffer);
            } else if (branchNodeType instanceof NonBranchNodeCase) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((NonBranchNodeCase)branchNodeType).getNonBranchNodeList(), buffer);
            }
        }
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p2mp.getLoadBalancing(), buffer);
    }

    protected void serializeMonitoringRequest(MonitoringRequest monReq, ByteBuf out) {
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)monReq.getMonitoring(), out);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)monReq.getPccIdReq(), out);
        if (monReq.getPceIdList() != null) {
            for (PceIdList pceId : monReq.getPceIdList()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)pceId.getPceId(), out);
            }
        }
    }

    protected Message validate(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        List<Requests> requests;
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrep message cannot be empty.");
        }
        PcreqMessageBuilder mBuilder = new PcreqMessageBuilder().setMonitoringRequest(this.getMonitoring(objects));
        List<Svec> svecs = this.getSvecs(objects);
        if (!svecs.isEmpty()) {
            mBuilder.setSvec(svecs);
        }
        if ((requests = this.getRequests(objects, errors)) != null) {
            mBuilder.setRequests(requests);
        } else {
            errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RP_MISSING, Optional.empty()));
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new PcreqBuilder().setPcreqMessage(mBuilder.build()).build();
    }

    protected List<Svec> getSvecs(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        SvecBuilder sBuilder;
        Svec svecComp;
        ArrayList<Svec> svecList = new ArrayList<Svec>();
        while (!objects.isEmpty() && (svecComp = PCEPRequestMessageParser.getValidSvec(sBuilder = new SvecBuilder(), objects)) != null) {
            svecList.add(svecComp);
        }
        return svecList;
    }

    protected List<Requests> getRequests(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) {
        ArrayList<Requests> requests = new ArrayList<Requests>();
        while (!objects.isEmpty()) {
            RequestsBuilder rBuilder = new RequestsBuilder();
            Rp rpObj = null;
            if (!(objects.get(0) instanceof Rp)) {
                errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RP_MISSING, Optional.empty()));
                return null;
            }
            rpObj = (Rp)objects.get(0);
            objects.remove(0);
            if (!rpObj.isProcessingRule().booleanValue()) {
                errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, Optional.empty()));
            } else {
                rBuilder.setRp(rpObj);
            }
            List vendorInfo = PCEPRequestMessageParser.addVendorInformationObjects(objects);
            if (!vendorInfo.isEmpty()) {
                rBuilder.setVendorInformationObject(vendorInfo);
            }
            if (rpObj.isPathKey().booleanValue() && objects.get(0) instanceof PathKey) {
                rBuilder.setPathKeyExpansion(new PathKeyExpansionBuilder().setPathKey((PathKey)objects.get(0)).build());
            }
            if (objects.isEmpty() || !(objects.get(0) instanceof EndpointsObj)) {
                errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.END_POINTS_MISSING, Optional.of(rpObj)));
                return null;
            }
            if (!rpObj.isP2mp().booleanValue()) {
                P2pBuilder p2pBuilder = new P2pBuilder();
                EndpointsObj ep = (EndpointsObj)objects.get(0);
                objects.remove(0);
                if (!ep.isProcessingRule().booleanValue()) {
                    errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, Optional.of(rpObj)));
                } else {
                    p2pBuilder.setEndpointsObj(ep);
                }
                SegmentComputation segm = this.getP2PSegmentComputation(p2pBuilder, objects, errors, rpObj);
                if (segm != null) {
                    rBuilder.setSegmentComputation(segm);
                }
            } else {
                SegmentComputation segm = this.getP2MPSegmentComputation(objects, errors, rpObj);
                if (segm != null) {
                    rBuilder.setSegmentComputation(segm);
                }
            }
            requests.add(rBuilder.build());
        }
        return requests;
    }

    protected SegmentComputation getP2PSegmentComputation(P2pBuilder builder, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors, Rp rp) {
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        ArrayList<VendorInformationObject> viObjects = new ArrayList<VendorInformationObject>();
        P2PState p2PState = P2PState.INIT;
        while (!objects.isEmpty() && p2PState != P2PState.END) {
            if ((p2PState = PCEPRequestMessageParser.insertP2PObject(p2PState, objects, viObjects, builder, metrics, errors, rp)).equals((Object)P2PState.END)) continue;
            objects.remove(0);
        }
        if (!metrics.isEmpty()) {
            builder.setMetrics(metrics);
        }
        if (!viObjects.isEmpty()) {
            builder.setVendorInformationObject(viObjects);
        }
        if (rp.isReoptimization().booleanValue() && builder.getBandwidth() != null && !builder.getReportedRoute().getReoptimizationBandwidth().getBandwidth().equals((Object)new Bandwidth(new byte[]{0})) && builder.getReportedRoute().getRro() == null) {
            errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RRO_MISSING, Optional.of(rp)));
            return null;
        }
        return new SegmentComputationBuilder().setP2p(builder.build()).build();
    }

    private static P2PState insertP2PObject(P2PState p2PState, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<VendorInformationObject> viObjects, P2pBuilder builder, List<Metrics> metrics, List<Message> errors, Rp rp) {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.get(0);
        switch (p2PState) {
            case INIT: {
                if (obj instanceof Rro) {
                    builder.setRro((Rro)obj);
                    objects.remove(0);
                    org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object nextObj = objects.get(0);
                    if (nextObj instanceof ReoptimizationBandwidth) {
                        builder.setReoptimizationBandwidth((ReoptimizationBandwidth)nextObj);
                    }
                    return P2PState.REPORTED_IN;
                }
            }
            case REPORTED_IN: {
                if (obj instanceof VendorInformationObject) {
                    viObjects.add((VendorInformationObject)obj);
                    return P2PState.REPORTED_IN;
                }
            }
            case VENDOR_INFO_LIST: {
                if (obj instanceof LoadBalancing) {
                    builder.setLoadBalancing((LoadBalancing)obj);
                    return P2PState.LOAD_BIN;
                }
            }
            case LOAD_BIN: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return P2PState.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth) {
                    builder.setBandwidth((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth)obj);
                    return P2PState.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric) {
                    metrics.add(new MetricsBuilder().setMetric((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric)obj).build());
                    return P2PState.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return P2PState.IRO_IN;
                }
            }
            case IRO_IN: {
                if (obj instanceof Rro) {
                    builder.setRro((Rro)obj);
                    return P2PState.RRO_IN;
                }
            }
            case RRO_IN: {
                if (obj instanceof Xro) {
                    builder.setXro((Xro)obj);
                    return P2PState.XRO_IN;
                }
            }
            case XRO_IN: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return P2PState.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof ClassType) {
                    ClassType classType = (ClassType)obj;
                    if (!classType.isProcessingRule().booleanValue()) {
                        errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, Optional.of(rp)));
                    } else {
                        builder.setClassType(classType);
                    }
                    return P2PState.CT_IN;
                }
            }
            case CT_IN: 
            case END: {
                return P2PState.END;
            }
        }
        return p2PState;
    }

    private static SvecState insertP2PObject(SvecState state, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, SvecBuilder builder, List<Metrics> metrics, List<VendorInformationObject> viObjects) {
        switch (state) {
            case INIT: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return SvecState.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof Gc) {
                    builder.setGc((Gc)obj);
                    return SvecState.GC_IN;
                }
            }
            case GC_IN: {
                if (obj instanceof Xro) {
                    builder.setXro((Xro)obj);
                    return SvecState.XRO_IN;
                }
            }
            case XRO_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric) {
                    metrics.add(new MetricsBuilder().setMetric((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric)obj).build());
                    return SvecState.XRO_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof VendorInformationObject) {
                    viObjects.add((VendorInformationObject)obj);
                    return SvecState.METRIC_IN;
                }
            }
            case VENDOR_INFO: 
            case END: {
                return SvecState.END;
            }
        }
        return state;
    }

    protected SegmentComputation getP2MPSegmentComputation(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors, Rp rp) {
        ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric> metrics = new ArrayList<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric>();
        P2mpBuilder builder = new P2mpBuilder();
        ArrayList<EndpointRroPair> epRros = new ArrayList<EndpointRroPair>();
        P2MPState state = P2MPState.RP;
        while (!objects.isEmpty() && state != P2MPState.END) {
            if ((state = PCEPRequestMessageParser.insertP2MPObject(state, objects, builder, epRros, metrics, errors, rp)).equals((Object)P2MPState.END)) continue;
            objects.remove(0);
        }
        if (!epRros.isEmpty()) {
            builder.setEndpointRroPair(epRros);
        }
        if (!metrics.isEmpty()) {
            builder.setMetric(metrics);
        }
        if (!(!rp.isReoptimization().booleanValue() || builder.getBandwidth() == null || this.isValidReoptimizationRro(epRros) && this.isValidReoptimizationBandwidth(epRros))) {
            errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RRO_MISSING, Optional.of(rp)));
        }
        return new SegmentComputationBuilder().setP2mp(builder.build()).build();
    }

    private boolean isValidReoptimizationRro(List<EndpointRroPair> epRros) {
        for (EndpointRroPair epRro : epRros) {
            if (epRro.getRros() != null && !epRro.getRros().isEmpty()) continue;
            return false;
        }
        return true;
    }

    private boolean isValidReoptimizationBandwidth(List<EndpointRroPair> epRros) {
        for (EndpointRroPair epRro : epRros) {
            if (epRro.getReoptimizationBandwidth() != null) continue;
            return false;
        }
        return true;
    }

    private static P2MPState insertP2MPObject(P2MPState p2MPState, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, P2mpBuilder builder, List<EndpointRroPair> epRros, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.requests.segment.computation.p2mp.Metric> metrics, List<Message> errors, Rp rp) {
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.get(0);
        switch (p2MPState) {
            case RP: {
                if (obj instanceof EndpointsObj) {
                    EndpointRroPairBuilder rroPairBuilder = new EndpointRroPairBuilder();
                    if (obj.isProcessingRule().booleanValue()) {
                        rroPairBuilder.setEndpointsObj((EndpointsObj)obj);
                    } else {
                        errors.add(PCEPRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, Optional.of(rp)));
                    }
                    epRros.add(rroPairBuilder.setRros(new ArrayList()).build());
                    return P2MPState.ENDPOINT;
                }
            }
            case ENDPOINT: {
                if (obj instanceof Rro || obj instanceof Srro) {
                    if (obj.isProcessingRule().booleanValue()) {
                        int lastIndex = epRros.size() - 1;
                        EndpointRroPair endpointRroPair = epRros.get(lastIndex);
                        List rros = endpointRroPair.getRros();
                        if (obj instanceof Rro) {
                            rros.add(new RrosBuilder().setRouteObject((RouteObject)new ReportedRouteObjectCaseBuilder().setRro((Rro)obj).build()).build());
                        } else {
                            rros.add(new RrosBuilder().setRouteObject((RouteObject)new SecondaryReportedRouteObjectCaseBuilder().setSrro((Srro)obj).build()).build());
                        }
                        epRros.remove(lastIndex);
                        epRros.add(lastIndex, new EndpointRroPairBuilder(endpointRroPair).setRros(rros).build());
                    }
                    return P2MPState.ENDPOINT;
                }
            }
            case RRO_SRRO: {
                if (obj instanceof ReoptimizationBandwidth) {
                    int lastIndex = epRros.size() - 1;
                    EndpointRroPair endpointRroPair = epRros.get(lastIndex);
                    epRros.remove(lastIndex);
                    epRros.add(lastIndex, new EndpointRroPairBuilder(endpointRroPair).setReoptimizationBandwidth((ReoptimizationBandwidth)obj).build());
                    return P2MPState.BANDWIDTH;
                }
            }
            case BANDWIDTH: {
                if (obj instanceof EndpointsObj) {
                    return P2MPState.RP;
                }
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return P2MPState.OF_IN;
                }
            }
            case OF_IN: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return P2MPState.LSPA_IN;
                }
            }
            case LSPA_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth) {
                    builder.setBandwidth((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth)obj);
                    return P2MPState.BANDWIDTH_IN;
                }
            }
            case BANDWIDTH_IN: {
                if (obj instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric) {
                    metrics.add(new MetricBuilder().setMetric((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric)obj).build());
                    return P2MPState.BANDWIDTH_IN;
                }
            }
            case METRIC_IN: {
                if (obj instanceof Iro) {
                    builder.setIroBncChoice((IroBncChoice)new IroCaseBuilder().setIro((Iro)obj).build());
                    return P2MPState.IRO_BNC_IN;
                }
                if (obj instanceof BranchNodeList) {
                    builder.setIroBncChoice((IroBncChoice)new BncCaseBuilder().setBranchNodeType((BranchNodeType)new BranchNodeCaseBuilder().setBranchNodeList((BranchNodeList)obj).build()).build());
                    return P2MPState.IRO_BNC_IN;
                }
                if (obj instanceof NonBranchNodeList) {
                    builder.setIroBncChoice((IroBncChoice)new BncCaseBuilder().setBranchNodeType((BranchNodeType)new NonBranchNodeCaseBuilder().setNonBranchNodeList((NonBranchNodeList)obj).build()).build());
                    return P2MPState.IRO_BNC_IN;
                }
            }
            case IRO_BNC_IN: {
                if (!(obj instanceof LoadBalancing)) break;
                builder.setLoadBalancing((LoadBalancing)obj);
                return P2MPState.LOAD_BIN;
            }
        }
        return P2MPState.END;
    }

    private static Svec getValidSvec(SvecBuilder builder, List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        Preconditions.checkArgument((objects != null && !objects.isEmpty() ? 1 : 0) != 0, (Object)"Passed list can't be null or empty.");
        if (!(objects.get(0) instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec)) {
            return null;
        }
        builder.setSvec((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec)objects.get(0));
        objects.remove(0);
        ArrayList<Metrics> metrics = new ArrayList<Metrics>();
        ArrayList<VendorInformationObject> viObjects = new ArrayList<VendorInformationObject>();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = null;
        SvecState state = SvecState.INIT;
        while (!objects.isEmpty() && !state.equals((Object)SvecState.END)) {
            obj = objects.get(0);
            if ((state = PCEPRequestMessageParser.insertP2PObject(state, obj, builder, metrics, viObjects)).equals((Object)SvecState.END)) continue;
            objects.remove(0);
        }
        if (!viObjects.isEmpty()) {
            builder.setVendorInformationObject(viObjects);
        }
        return builder.build();
    }

    protected MonitoringRequest getMonitoring(List<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        MonitoringRequestBuilder builder = new MonitoringRequestBuilder();
        if (objects.isEmpty() || !(objects.get(0) instanceof Monitoring)) {
            return null;
        }
        builder.setMonitoring((Monitoring)objects.get(0));
        objects.remove(0);
        if (!objects.isEmpty() && objects.get(0) instanceof PccIdReq) {
            builder.setPccIdReq((PccIdReq)objects.get(0));
            objects.remove(0);
        }
        ArrayList<PceIdList> pceIdList = new ArrayList<PceIdList>();
        while (!objects.isEmpty() && objects.get(0) instanceof PceId) {
            pceIdList.add(new PceIdListBuilder().setPceId((PceId)objects.get(0)).build());
            objects.remove(0);
        }
        if (!pceIdList.isEmpty()) {
            builder.setPceIdList(pceIdList);
        }
        return builder.build();
    }

    private static enum SvecState {
        INIT,
        OF_IN,
        GC_IN,
        XRO_IN,
        METRIC_IN,
        VENDOR_INFO,
        END;

    }

    private static enum P2MPState {
        RP,
        ENDPOINT,
        RRO_SRRO,
        BANDWIDTH,
        OF_IN,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_BNC_IN,
        LOAD_BIN,
        END;

    }

    private static enum P2PState {
        INIT,
        REPORTED_IN,
        VENDOR_INFO_LIST,
        LOAD_BIN,
        LSPA_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        RRO_IN,
        XRO_IN,
        OF_IN,
        CT_IN,
        END;

    }
}

