/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key.PathKeys;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.path.key.PathKeysBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;

public final class PCEPPathKeyObjectParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 16;
    private static final int TYPE = 1;

    public PCEPPathKeyObjectParser(EROSubobjectRegistry subReg) {
        super(subReg, 16, 1);
    }

    public PathKey parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        ArrayList<PathKeys> pk = new ArrayList<PathKeys>();
        List<Subobject> subs = this.parseSubobjects(bytes);
        for (Subobject sub : subs) {
            PathKeyCase pkc = (PathKeyCase)sub.getSubobjectType();
            pk.add(new PathKeysBuilder().setLoose(sub.isLoose()).setPceId(pkc.getPathKey().getPceId()).setPathKey(pkc.getPathKey().getPathKey()).build());
        }
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKeyBuilder builder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.key.object.PathKeyBuilder().setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setPathKeys(pk);
        return builder.build();
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof PathKey), (String)"Wrong instance of PCEPObject. Passed %s. Needed PathKeyObject.", object.getClass());
        PathKey pkey = (PathKey)object;
        ByteBuf body = Unpooled.buffer();
        List pks = pkey.getPathKeys();
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        for (PathKeys pk : pks) {
            subs.add(new SubobjectBuilder().setLoose(pk.isLoose()).setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(new PathKeyBuilder().setPathKey(pk.getPathKey()).setPceId(pk.getPceId()).build()).build()).build());
        }
        this.serializeSubobject(subs, body);
        ObjectUtil.formatSubobject((int)1, (int)16, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

