/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTimeBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPProcTimeObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 26;
    private static final int TYPE = 1;
    private static final int RESERVED = 2;
    private static final int FLAGS = 16;
    private static final int COUNT_FIELDS = 5;
    private static final int BODY_SIZE = 38;
    private static final int E_FLAG_POSITION = 15;

    public PCEPProcTimeObjectParser() {
        super(26, 1);
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof ProcTime), (String)"Wrong instance of PCEPObject. Passed %s. Needed ProcTimeObject.", object.getClass());
        ProcTime procTime = (ProcTime)object;
        ByteBuf body = Unpooled.buffer((int)38);
        body.writeZero(2);
        BitArray flagBits = new BitArray(16);
        flagBits.set(15, procTime.isEstimated());
        flagBits.toByteBuf(body);
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint32)procTime.getCurrentProcTime());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint32)procTime.getMinProcTime());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint32)procTime.getMaxProcTime());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint32)procTime.getAverageProcTime());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint32)procTime.getVarianceProcTime());
        ObjectUtil.formatSubobject((int)1, (int)26, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        buffer.skipBytes(2);
        BitArray flagBits = BitArray.valueOf((ByteBuf)buffer, (int)16);
        return new ProcTimeBuilder().setEstimated(Boolean.valueOf(flagBits.get(15))).setCurrentProcTime(ByteBufUtils.readUint32((ByteBuf)buffer)).setMinProcTime(ByteBufUtils.readUint32((ByteBuf)buffer)).setMaxProcTime(ByteBufUtils.readUint32((ByteBuf)buffer)).setAverageProcTime(ByteBufUtils.readUint32((ByteBuf)buffer)).setVarianceProcTime(ByteBufUtils.readUint32((ByteBuf)buffer)).build();
    }
}

