/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractRROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.Rro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.RroBuilder;

public final class PCEPReportedRouteObjectParser
extends AbstractRROWithSubobjectsParser {
    public static final int CLASS = 8;
    public static final int TYPE = 1;

    public PCEPReportedRouteObjectParser(RROSubobjectRegistry subobjReg) {
        super(subobjReg, 8, 1);
    }

    public Rro parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        RroBuilder builder = new RroBuilder().setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setSubobject(this.parseSubobjects(bytes.slice()));
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Rro), (String)"Wrong instance of PCEPObject. Passed %s. Needed RroObject.", object.getClass());
        Rro obj = (Rro)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(obj.getSubobject(), body);
        ObjectUtil.formatSubobject((int)1, (int)8, (Boolean)object.isProcessingRule(), (Boolean)object.isIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

