/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.end.points;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.Ipv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case.Ipv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.ipv4._case.Ipv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPEndPointsIpv4ObjectParser
extends CommonObjectParser {
    private static final int CLASS = 4;
    private static final int TYPE = 1;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPEndPointsIpv4ObjectParser.class);

    public PCEPEndPointsIpv4ObjectParser() {
        super(4, 1);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, Ipv4 ipv4, ByteBuf buffer) {
        ByteBuf body = Unpooled.buffer((int)8);
        Preconditions.checkArgument((ipv4.getSourceIpv4Address() != null ? 1 : 0) != 0, (java.lang.Object)"SourceIpv4Address is mandatory.");
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)ipv4.getSourceIpv4Address(), (ByteBuf)body);
        Preconditions.checkArgument((ipv4.getDestinationIpv4Address() != null ? 1 : 0) != 0, (java.lang.Object)"DestinationIpv4Address is mandatory.");
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)ipv4.getDestinationIpv4Address(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)1, (int)4, (Boolean)processing, (Boolean)ignore, (ByteBuf)body, (ByteBuf)buffer);
    }

    public Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        if (!header.isProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on Endpoints OBJECT, ignoring it.");
            return new UnknownObject(PCEPErrors.P_FLAG_NOT_SET, (Object)builder.build());
        }
        if (bytes.readableBytes() != 8) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        Ipv4Builder ipv4bldr = new Ipv4Builder().setSourceIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)bytes)).setDestinationIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)bytes));
        builder.setIgnore(header.isIgnore()).setProcessingRule(header.isProcessingRule()).setAddressFamily((AddressFamily)new Ipv4CaseBuilder().setIpv4(ipv4bldr.build()).build());
        return builder.build();
    }
}

