/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.end.points;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv4CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv4._case.P2mpIpv4Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPP2MPEndPointsIpv4ObjectParser
extends CommonObjectParser {
    private static final int CLASS = 4;
    private static final int TYPE = 3;
    private static final int LEAF_TYPE_SIZE = 32;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPP2MPEndPointsIpv4ObjectParser.class);

    public PCEPP2MPEndPointsIpv4ObjectParser() {
        super(4, 3);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, P2mpIpv4 p2mpIpv4, ByteBuf buffer) {
        List dest = p2mpIpv4.getDestinationIpv4Address();
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"DestinationIpv4Address is mandatory.");
        ByteBuf body = Unpooled.buffer((int)(36 + 4 * dest.size()));
        Preconditions.checkArgument((p2mpIpv4.getSourceIpv4Address() != null ? 1 : 0) != 0, (Object)"SourceIpv4Address is mandatory.");
        body.writeInt(p2mpIpv4.getP2mpLeaves().getIntValue());
        Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)p2mpIpv4.getSourceIpv4Address(), (ByteBuf)body);
        dest.forEach(ipv4 -> Ipv4Util.writeIpv4Address((Ipv4AddressNoZone)ipv4, (ByteBuf)body));
        ObjectUtil.formatSubobject((int)3, (int)4, (Boolean)processing, (Boolean)ignore, (ByteBuf)body, (ByteBuf)buffer);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        EndpointsObjBuilder builder = new EndpointsObjBuilder();
        if (!header.isProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on Endpoints OBJECT, ignoring it.");
            return new UnknownObject(PCEPErrors.P_FLAG_NOT_SET, (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)builder.build());
        }
        if (bytes.readableBytes() % 4 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        builder.setIgnore(header.isIgnore());
        builder.setProcessingRule(header.isProcessingRule());
        P2mpIpv4Builder p2mpIpv4Builder = new P2mpIpv4Builder();
        p2mpIpv4Builder.setP2mpLeaves(P2mpLeaves.forValue((int)bytes.readInt()));
        p2mpIpv4Builder.setSourceIpv4Address(Ipv4Util.addressForByteBuf((ByteBuf)bytes));
        ArrayList<Ipv4AddressNoZone> dest = new ArrayList<Ipv4AddressNoZone>();
        while (bytes.isReadable()) {
            dest.add(Ipv4Util.addressForByteBuf((ByteBuf)bytes));
        }
        p2mpIpv4Builder.setDestinationIpv4Address(dest);
        builder.setAddressFamily((AddressFamily)new P2mpIpv4CaseBuilder().setP2mpIpv4(p2mpIpv4Builder.build()).build());
        return builder.build();
    }
}

