/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class RROPathKey128SubobjectParser
implements RROSubobjectParser {
    public static final int TYPE = 65;
    protected static final int PCE128_ID_F_LENGTH = 16;
    private static final int PK_F_OFFSET = 0;
    private static final int PK_F_LENGTH = 2;
    private static final int PCE_ID_F_OFFSET = 2;
    private static final int CONTENT128_LENGTH = 18;

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 18) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >18.");
        }
        return new SubobjectBuilder().setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(new PathKeyBuilder().setPathKey(new PathKey(ByteBufUtils.readUint16((ByteBuf)buffer))).setPceId(new PceId(ByteArray.readBytes((ByteBuf)buffer, (int)16))).build()).build()).build();
    }

    public static void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        PathKeyCase pkcase = (PathKeyCase)subobject.getSubobjectType();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.record.route.subobjects.subobject.type.path.key._case.PathKey pk = pkcase.getPathKey();
        ByteBuf body = Unpooled.buffer();
        PathKey pathKey = pk.getPathKey();
        Preconditions.checkArgument((pathKey != null ? 1 : 0) != 0, (Object)"PathKey is mandatory.");
        ByteBufUtils.write((ByteBuf)body, (Uint16)pathKey.getValue());
        PceId pceId = pk.getPceId();
        Preconditions.checkArgument((pceId != null ? 1 : 0) != 0, (Object)"PceId is mandatory.");
        body.writeBytes(pceId.getValue());
        RROSubobjectUtil.formatSubobject((int)65, (ByteBuf)body, (ByteBuf)buffer);
    }
}

