/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.LspaBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.lspa.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.AttributeFilter;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPLspaObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 9;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 8;
    private static final int L_FLAG_OFFSET = 7;
    private static final int RESERVED = 1;

    public PCEPLspaObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 9, 1);
    }

    public Lspa parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        LspaBuilder builder = new LspaBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setExcludeAny(new AttributeFilter(ByteBufUtils.readUint32((ByteBuf)bytes))).setIncludeAll(new AttributeFilter(ByteBufUtils.readUint32((ByteBuf)bytes))).setIncludeAny(new AttributeFilter(ByteBufUtils.readUint32((ByteBuf)bytes))).setSetupPriority(ByteBufUtils.readUint8((ByteBuf)bytes)).setHoldPriority(ByteBufUtils.readUint8((ByteBuf)bytes));
        BitArray flags = BitArray.valueOf((byte)bytes.readByte());
        builder.setLocalProtectionDesired(Boolean.valueOf(flags.get(7)));
        TlvsBuilder tbuilder = new TlvsBuilder();
        bytes.skipBytes(1);
        this.parseTlvs(tbuilder, bytes.slice());
        return builder.setTlvs(tbuilder.build()).build();
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Lspa), (String)"Wrong instance of PCEPObject. Passed %s. Needed LspaObject.", object.getClass());
        Lspa lspaObj = (Lspa)object;
        ByteBuf body = Unpooled.buffer();
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getExcludeAny(), body);
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getIncludeAny(), body);
        PCEPLspaObjectParser.writeAttributeFilter(lspaObj.getIncludeAll(), body);
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)lspaObj.getSetupPriority());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)lspaObj.getHoldPriority());
        BitArray flags = new BitArray(8);
        flags.set(7, lspaObj.getLocalProtectionDesired());
        flags.toByteBuf(body);
        body.writeZero(1);
        this.serializeTlvs(lspaObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)9, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    private static void writeAttributeFilter(AttributeFilter attributeFilter, ByteBuf body) {
        if (attributeFilter != null) {
            ByteBufUtils.write((ByteBuf)body, (Uint32)attributeFilter.getValue());
        } else {
            body.writeInt(0);
        }
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

