/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.end.points;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.P2mpLeaves;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.AddressFamily;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.P2mpIpv6CaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.address.family.p2mp.ipv6._case.P2mpIpv6Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.endpoints.object.EndpointsObjBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPP2MPEndPointsIpv6ObjectParser
extends CommonObjectParser {
    private static final int CLASS = 4;
    private static final int TYPE = 4;
    private static final int LEAF_TYPE_SIZE = 32;
    private static final Logger LOG = LoggerFactory.getLogger(PCEPP2MPEndPointsIpv6ObjectParser.class);

    public PCEPP2MPEndPointsIpv6ObjectParser() {
        super(4, 4);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, P2mpIpv6 p2mpIpv6, ByteBuf buffer) {
        List dest = p2mpIpv6.getDestinationIpv6Address();
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"DestinationIpv6Address is mandatory.");
        ByteBuf body = Unpooled.buffer((int)(48 + 16 * dest.size()));
        Preconditions.checkArgument((p2mpIpv6.getSourceIpv6Address() != null ? 1 : 0) != 0, (Object)"SourceIpv6Address is mandatory.");
        body.writeInt(p2mpIpv6.getP2mpLeaves().getIntValue());
        Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)p2mpIpv6.getSourceIpv6Address(), (ByteBuf)body);
        dest.forEach(ipv6 -> Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)ipv6, (ByteBuf)body));
        ObjectUtil.formatSubobject((int)4, (int)4, (Boolean)processing, (Boolean)ignore, (ByteBuf)body, (ByteBuf)buffer);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (!header.getProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on Endpoints OBJECT, ignoring it.");
            return new UnknownObject(PCEPErrors.P_FLAG_NOT_SET, (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)new EndpointsObjBuilder().build());
        }
        if (bytes.readableBytes() % 16 != 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        P2mpIpv6Builder p2mpIpv6Builder = new P2mpIpv6Builder().setP2mpLeaves(P2mpLeaves.forValue((int)bytes.readInt())).setSourceIpv6Address(Ipv6Util.addressForByteBuf((ByteBuf)bytes));
        ArrayList<Ipv6AddressNoZone> dest = new ArrayList<Ipv6AddressNoZone>();
        while (bytes.isReadable()) {
            dest.add(Ipv6Util.addressForByteBuf((ByteBuf)bytes));
        }
        p2mpIpv6Builder.setDestinationIpv6Address(dest);
        return new EndpointsObjBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setAddressFamily((AddressFamily)new P2mpIpv6CaseBuilder().setP2mpIpv6(p2mpIpv6Builder.build()).build()).build();
    }
}

