/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.XROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.XROSubobjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.ExcludeRouteSubobjects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.SrlgId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.SrlgCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.SrlgCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case.Srlg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.srlg._case.SrlgBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class XROSrlgSubobjectParser
implements XROSubobjectParser,
XROSubobjectSerializer {
    public static final int TYPE = 34;
    private static final int CONTENT_LENGTH = 6;

    public Subobject parseSubobject(ByteBuf buffer, boolean mandatory) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: 6.");
        }
        SubobjectBuilder builder = new SubobjectBuilder().setMandatory(Boolean.valueOf(mandatory)).setSubobjectType((SubobjectType)new SrlgCaseBuilder().setSrlg(new SrlgBuilder().setSrlgId(new SrlgId(ByteBufUtils.readUint32((ByteBuf)buffer))).build()).build());
        buffer.readByte();
        return builder.setAttribute(ExcludeRouteSubobjects.Attribute.forValue((int)buffer.readUnsignedByte())).build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof SrlgCase), (String)"Unknown subobject instance. Passed %s. Needed SrlgCase.", subobject.getSubobjectType().getClass());
        Srlg specObj = ((SrlgCase)subobject.getSubobjectType()).getSrlg();
        ByteBuf body = Unpooled.buffer((int)6);
        SrlgId srlgId = specObj.getSrlgId();
        Preconditions.checkArgument((srlgId != null ? 1 : 0) != 0, (Object)"SrlgId is mandatory.");
        ByteBufUtils.write((ByteBuf)body, (Uint32)srlgId.getValue());
        ExcludeRouteSubobjects.Attribute attribute = subobject.getAttribute();
        Preconditions.checkArgument((attribute != null ? 1 : 0) != 0, (Object)"Attribute is mandatory.");
        body.writeByte(0);
        body.writeByte(attribute.getIntValue());
        XROSubobjectUtil.formatSubobject((int)34, (Boolean)subobject.getMandatory(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

