/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.tlv;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvParser;
import org.opendaylight.protocol.pcep.spi.TlvSerializer;
import org.opendaylight.protocol.pcep.spi.TlvUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissingBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class ReqMissingTlvParser
implements TlvParser,
TlvSerializer {
    public static final int TYPE = 3;

    public ReqMissing parseTlv(ByteBuf buffer) throws PCEPDeserializerException {
        if (buffer == null) {
            return null;
        }
        return new ReqMissingBuilder().setRequestId(new RequestId(ByteBufUtils.readUint32((ByteBuf)buffer))).build();
    }

    public void serializeTlv(Tlv tlv, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(tlv instanceof ReqMissing), (Object)"ReqMissingTlv is mandatory.");
        ReqMissing req = (ReqMissing)tlv;
        ByteBuf body = Unpooled.buffer();
        RequestId reqId = req.getRequestId();
        Preconditions.checkArgument((reqId != null ? 1 : 0) != 0, (Object)"RequestId is mandatory.");
        ByteBufUtils.write((ByteBuf)body, (Uint32)reqId.getValue());
        TlvUtil.formatTlv((int)3, (ByteBuf)body, (ByteBuf)buffer);
    }
}

