/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Queue;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Close;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.CloseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.CloseMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message.CCloseMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.message.CCloseMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.close.object.CClose;

public class PCEPCloseMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 7;

    public PCEPCloseMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof CloseMessage), (String)"Wrong instance of Message. Passed instance of %s. Need CloseMessage.", message.getClass());
        CCloseMessage close = ((CloseMessage)message).getCCloseMessage();
        Preconditions.checkArgument((close.getCClose() != null ? 1 : 0) != 0, (java.lang.Object)"Close Object must be present in Close Message.");
        ByteBuf buffer = Unpooled.buffer();
        this.serializeObject((Object)close.getCClose(), buffer);
        MessageUtil.formatMessage((int)7, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected Close validate(Queue<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (java.lang.Object)"Passed list can't be null.");
        Object o = objects.poll();
        if (!(o instanceof CClose)) {
            throw new PCEPDeserializerException("Close message doesn't contain CLOSE object.");
        }
        CCloseMessage msg = new CCloseMessageBuilder().setCClose((CClose)o).build();
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + objects);
        }
        return new CloseBuilder().setCCloseMessage(msg).build();
    }
}

