/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractXROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.Xro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.XroBuilder;

public final class PCEPExcludeRouteObjectParser
extends AbstractXROWithSubobjectsParser {
    private static final int CLASS = 17;
    private static final int TYPE = 1;
    private static final int FLAGS_OFFSET = 3;

    public PCEPExcludeRouteObjectParser(XROSubobjectRegistry registry) {
        super(registry, 17, 1);
    }

    public Xro parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        bytes.skipBytes(3);
        return new XroBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setFlags(new Xro.Flags(Boolean.valueOf(bytes.readBoolean()))).setSubobject(this.parseSubobjects(bytes.slice())).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Xro), (String)"Wrong instance of PCEPObject. Passed %s. Needed XroObject.", object.getClass());
        Xro obj = (Xro)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(3);
        Xro.Flags flags = obj.getFlags();
        body.writeBoolean(flags != null && Boolean.TRUE.equals(flags.getFail()));
        this.serializeSubobject(obj.getSubobject(), body);
        ObjectUtil.formatSubobject((int)1, (int)17, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

