/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedBytes;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.XROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractXROWithSubobjectsParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractXROWithSubobjectsParser.class);
    private static final int HEADER_LENGTH = 2;
    private final XROSubobjectRegistry subobjReg;

    protected AbstractXROWithSubobjectsParser(XROSubobjectRegistry subobjReg, int objectClass, int objectType) {
        super(objectClass, objectType);
        this.subobjReg = Objects.requireNonNull(subobjReg);
    }

    protected List<Subobject> parseSubobjects(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        ArrayList<Subobject> subs = new ArrayList<Subobject>();
        while (buffer.isReadable()) {
            boolean mandatory = (buffer.getUnsignedByte(buffer.readerIndex()) & 0x80) != 0;
            byte type = UnsignedBytes.checkedCast((long)(buffer.readUnsignedByte() & 0xFF & 0xFFFFFF7F));
            int length = buffer.readUnsignedByte() - 2;
            if (length > buffer.readableBytes()) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + length + "; Expected: <= " + buffer.readableBytes());
            }
            LOG.debug("Attempt to parse subobject from bytes: {}", (Object)ByteBufUtil.hexDump((ByteBuf)buffer));
            Subobject sub = this.subobjReg.parseSubobject((int)type, buffer.readSlice(length), mandatory);
            if (sub == null) {
                LOG.warn("Parsing failed for subobject type: {}. Ignoring subobject.", (Object)type);
                continue;
            }
            LOG.debug("Subobject was parsed. {}", (Object)sub);
            subs.add(sub);
        }
        return subs;
    }

    protected final void serializeSubobject(List<Subobject> subobjects, ByteBuf buffer) {
        Preconditions.checkArgument((subobjects != null && !subobjects.isEmpty() ? 1 : 0) != 0, (Object)"XRO must contain at least one subobject.");
        for (Subobject subobject : subobjects) {
            this.subobjReg.serializeSubobject(subobject, buffer);
        }
    }
}

