/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.Gc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.GcBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.gc.object.gc.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPGlobalConstraintsObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 24;
    private static final int TYPE = 1;

    public PCEPGlobalConstraintsObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 24, 1);
    }

    public Gc parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Cannot be null or empty.");
        GcBuilder builder = new GcBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setMaxHop(ByteBufUtils.readUint8((ByteBuf)bytes)).setMaxUtilization(ByteBufUtils.readUint8((ByteBuf)bytes)).setMinUtilization(ByteBufUtils.readUint8((ByteBuf)bytes)).setOverBookingFactor(ByteBufUtils.readUint8((ByteBuf)bytes));
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        return builder.setTlvs(tlvsBuilder.build()).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Gc), (String)"Wrong instance of PCEPObject. Passed %s. Needed GcObject.", object.getClass());
        Gc specObj = (Gc)object;
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)specObj.getMaxHop());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)specObj.getMaxUtilization());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)specObj.getMinUtilization());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)specObj.getOverBookingFactor());
        this.serializeTlvs(specObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)24, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

