/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.bnc;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.parser.object.bnc.BNCUtil;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.non.branch.node.object.NonBranchNodeListBuilder;

public final class NonBranchNodeListObjectParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 31;
    private static final int TYPE = 2;

    public NonBranchNodeListObjectParser(EROSubobjectRegistry subobjReg) {
        super(subobjReg, 31, 2);
    }

    public NonBranchNodeList parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        return new NonBranchNodeListBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setSubobject(BNCUtil.toBncSubobject(this.parseSubobjects(bytes))).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof NonBranchNodeList), (String)"Wrong instance of PCEPObject. Passed %s. Needed NonBranchNodeList.", object.getClass());
        NonBranchNodeList nbnc = (NonBranchNodeList)object;
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(BNCUtil.toIroSubject(nbnc.getSubobject()), body);
        ObjectUtil.formatSubobject((int)2, (int)31, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

