/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.unreach;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import org.opendaylight.protocol.pcep.parser.object.unreach.PCEPIpv4UnreachDestinationParser;
import org.opendaylight.protocol.pcep.parser.object.unreach.PCEPIpv6UnreachDestinationParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.Destination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv4DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCase;

public final class PCEPUnreachDestinationSerializer
implements ObjectSerializer {
    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof UnreachDestinationObj), (String)"Wrong instance of PCEPObject. Passed %s. Needed UnreachDestinationObj.", object.getClass());
        UnreachDestinationObj uPObj = (UnreachDestinationObj)object;
        Destination destination = uPObj.getDestination();
        Boolean processing = object.getProcessingRule();
        Boolean ignore = object.getIgnore();
        if (destination instanceof Ipv6DestinationCase) {
            Ipv6DestinationCase ipv6 = (Ipv6DestinationCase)destination;
            PCEPIpv6UnreachDestinationParser.serializeObject(processing, ignore, ipv6, buffer);
        } else if (destination instanceof Ipv4DestinationCase) {
            Ipv4DestinationCase ipv4 = (Ipv4DestinationCase)destination;
            PCEPIpv4UnreachDestinationParser.serializeObject(processing, ignore, ipv4, buffer);
        }
    }
}

