/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.AsNumberCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.subobject.type.as.number._case.AsNumberBuilder;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

final class AsNumberCaseParser {
    private static final int CONTENT_LENGTH = 2;

    private AsNumberCaseParser() {
    }

    static AsNumberCase parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 2) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: 2.");
        }
        return new AsNumberCaseBuilder().setAsNumber(new AsNumberBuilder().setAsNumber(new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber(ByteBufUtils.readUint16((ByteBuf)buffer).toUint32())).build()).build();
    }

    static ByteBuf serializeSubobject(AsNumberCase asCase) {
        AsNumber asNumber = asCase.getAsNumber();
        ByteBuf body = Unpooled.buffer((int)2);
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.AsNumber asn = asNumber.getAsNumber();
        Preconditions.checkArgument((asn != null ? 1 : 0) != 0, (Object)"AsNumber is mandatory.");
        body.writeShort((int)asn.getValue().shortValue());
        return body;
    }
}

