/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.parser.subobject.RROIpv6PrefixSubobjectParser;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.Ipv4Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Prefix;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6Prefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.IpPrefixCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefix;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.ip.prefix._case.IpPrefixBuilder;

public class RROIpv4PrefixSubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 1;
    private static final int PREFIX_F_LENGTH = 1;
    private static final int FLAGS_SIZE = 8;
    private static final int PREFIX4_F_OFFSET = 4;
    private static final int CONTENT4_LENGTH = 6;
    private static final int LPA_F_OFFSET = 7;
    private static final int LPIU_F_OFFSET = 6;

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + ";");
        }
        short length = buffer.getUnsignedByte(4);
        IpPrefix prefix = new IpPrefixBuilder().setIpPrefix(new org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix(Ipv4Util.prefixForBytes((byte[])ByteArray.readBytes((ByteBuf)buffer, (int)4), (int)length))).build();
        buffer.skipBytes(1);
        BitArray flags = BitArray.valueOf((ByteBuf)buffer, (int)8);
        return new SubobjectBuilder().setProtectionAvailable(Boolean.valueOf(flags.get(7))).setProtectionInUse(Boolean.valueOf(flags.get(6))).setSubobjectType((SubobjectType)new IpPrefixCaseBuilder().setIpPrefix(prefix).build()).build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof IpPrefixCase), (String)"Unknown subobject instance. Passed %s. Needed IpPrefixCase.", subobject.getSubobjectType().getClass());
        IpPrefix specObj = ((IpPrefixCase)subobject.getSubobjectType()).getIpPrefix();
        org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpPrefix prefix = specObj.getIpPrefix();
        Ipv6Prefix ipv6Prefix = prefix.getIpv6Prefix();
        if (ipv6Prefix != null) {
            RROIpv6PrefixSubobjectParser.serializeSubobject(buffer, subobject, ipv6Prefix);
            return;
        }
        BitArray flags = new BitArray(8);
        flags.set(7, subobject.getProtectionAvailable());
        flags.set(6, subobject.getProtectionInUse());
        ByteBuf body = Unpooled.buffer((int)6);
        Preconditions.checkArgument((prefix.getIpv4Prefix() != null ? 1 : 0) != 0, (Object)"Ipv4Prefix is mandatory.");
        Ipv4Util.writeIpv4Prefix((Ipv4Prefix)prefix.getIpv4Prefix(), (ByteBuf)body);
        flags.toByteBuf(body);
        RROSubobjectUtil.formatSubobject((int)1, (ByteBuf)body, (ByteBuf)buffer);
    }
}

