/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.util;

import java.util.Queue;
import org.opendaylight.protocol.pcep.spi.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;

public final class Util {
    private Util() {
    }

    private static State insertObject(MetricPceBuilder metricPceBuilder, State state, Object obj) {
        switch (state) {
            case START: {
                if (obj instanceof ProcTime) {
                    metricPceBuilder.setProcTime((ProcTime)obj);
                    return State.PROC_TIME;
                }
            }
            case PROC_TIME: {
                if (obj instanceof Overload) {
                    metricPceBuilder.setOverload((Overload)obj);
                    return State.OVERLOAD;
                }
            }
            case OVERLOAD: 
            case END: {
                return State.END;
            }
        }
        return state;
    }

    public static MetricPce validateMonitoringMetrics(Queue<Object> objects) throws PCEPDeserializerException {
        Object pceId = objects.poll();
        if (!(pceId instanceof PceId)) {
            throw new PCEPDeserializerException("metric-pce-list must start with PCE-ID object.");
        }
        MetricPceBuilder metricPceBuilder = new MetricPceBuilder().setPceId((PceId)pceId);
        State state = State.START;
        Object obj = objects.peek();
        while (obj != null && (state = Util.insertObject(metricPceBuilder, state, obj)) != State.END) {
            objects.remove();
            obj = objects.peek();
        }
        return metricPceBuilder.build();
    }

    private static enum State {
        START,
        PROC_TIME,
        OVERLOAD,
        END;

    }
}

