/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.error.object.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.req.missing.tlv.ReqMissing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPErrorObjectParser
extends AbstractObjectWithTlvsParser<ErrorObjectBuilder> {
    private static final int CLASS = 13;
    private static final int TYPE = 1;
    private static final int FLAGS_F_LENGTH = 1;
    private static final int RESERVED = 1;

    public PCEPErrorObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 13, 1);
    }

    public ErrorObject parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        bytes.skipBytes(2);
        ErrorObjectBuilder builder = new ErrorObjectBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setType(ByteBufUtils.readUint8((ByteBuf)bytes)).setValue(ByteBufUtils.readUint8((ByteBuf)bytes));
        this.parseTlvs(builder, bytes.slice());
        return builder.build();
    }

    public void addTlv(ErrorObjectBuilder builder, Tlv tlv) {
        if (tlv instanceof ReqMissing && PCEPErrors.SYNC_PATH_COMP_REQ_MISSING.getErrorType().equals(builder.getType())) {
            builder.setTlvs(new TlvsBuilder().setReqMissing((ReqMissing)tlv).build());
        }
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof ErrorObject), (String)"Wrong instance of PCEPObject. Passed %s. Needed ErrorObject.", object.getClass());
        ErrorObject errObj = (ErrorObject)object;
        ByteBuf body = Unpooled.buffer();
        body.writeZero(2);
        ByteBufUtils.writeMandatory((ByteBuf)body, (Uint8)errObj.getType(), (String)"Type");
        ByteBufUtils.writeMandatory((ByteBuf)body, (Uint8)errObj.getValue(), (String)"Value");
        this.serializeTlvs(errObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)13, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            if (tlvs.getReqMissing() != null) {
                this.serializeTlv((Tlv)tlvs.getReqMissing(), body);
            }
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected void addVendorInformationTlvs(ErrorObjectBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setTlvs(new TlvsBuilder(builder.getTlvs()).setVendorInformationTlv(tlvs).build());
        }
    }
}

