/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancing;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.load.balancing.object.LoadBalancingBuilder;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPLoadBalancingObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 14;
    private static final int TYPE = 1;
    private static final int RESERVED = 2;
    private static final int FLAGS_F_LENGTH = 1;
    private static final int SIZE = 8;

    public PCEPLoadBalancingObjectParser() {
        super(14, 1);
    }

    public LoadBalancing parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() != 8) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: 8.");
        }
        bytes.skipBytes(3);
        return new LoadBalancingBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setMaxLsp(ByteBufUtils.readUint8((ByteBuf)bytes)).setMinBandwidth(new Bandwidth(ByteArray.readAllBytes((ByteBuf)bytes))).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof LoadBalancing), (String)"Wrong instance of PCEPObject. Passed %s. Needed LoadBalancingObject.", object.getClass());
        LoadBalancing specObj = (LoadBalancing)object;
        ByteBuf body = Unpooled.buffer((int)8);
        body.writeZero(3);
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)specObj.getMaxLsp());
        ByteBufWriteUtil.writeFloat32((Float32)specObj.getMinBandwidth(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)1, (int)14, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

