/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.no.path.tlvs.NoPathVector;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPNoPathObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 3;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 16;
    private static final int RESERVED_F_LENGTH = 1;
    private static final int C_FLAG_OFFSET = 0;

    public PCEPNoPathObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 3, 1);
    }

    public NoPath parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        Uint8 issue = ByteBufUtils.readUint8((ByteBuf)bytes);
        BitArray flags = BitArray.valueOf((ByteBuf)bytes, (int)16);
        bytes.skipBytes(1);
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        return new NoPathBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setNatureOfIssue(issue).setUnsatisfiedConstraints(Boolean.valueOf(flags.get(0))).setTlvs(tlvsBuilder.build()).build();
    }

    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof NoPathVector) {
            builder.setNoPathVector((NoPathVector)tlv);
        }
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof NoPath), (String)"Wrong instance of PCEPObject. Passed %s. Needed NoPathObject.", object.getClass());
        NoPath nPObj = (NoPath)object;
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.writeMandatory((ByteBuf)body, (Uint8)nPObj.getNatureOfIssue(), (String)"NatureOfIssue");
        BitArray flags = new BitArray(16);
        flags.set(0, nPObj.getUnsatisfiedConstraints());
        flags.toByteBuf(body);
        body.writeZero(1);
        this.serializeTlvs(nPObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)3, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            if (tlvs.getNoPathVector() != null) {
                this.serializeTlv((Tlv)tlvs.getNoPathVector(), body);
            }
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

