/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.stream.Collectors;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.object.AbstractEROWithSubobjectsParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectRegistry;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.explicit.route.object.Sero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.explicit.route.object.SeroBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.secondary.explicit.route.object.sero.SubobjectBuilder;

public final class PCEPSecondaryExplicitRouteObjecParser
extends AbstractEROWithSubobjectsParser {
    private static final int CLASS = 29;
    private static final int TYPE = 1;
    private static String EMPTY_ARRAY_ERROR = "Array of bytes is mandatory. Can't be null or empty.";

    public PCEPSecondaryExplicitRouteObjecParser(EROSubobjectRegistry subobjReg) {
        super(subobjReg, 29, 1);
    }

    public Sero parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (java.lang.Object)EMPTY_ARRAY_ERROR);
        SeroBuilder builder = new SeroBuilder();
        builder.setIgnore(header.getIgnore());
        builder.setProcessingRule(header.getProcessingRule());
        List<Subobject> subObjects = this.parseSubobjects(buffer);
        builder.setSubobject(subObjects.stream().map(so -> new SubobjectBuilder().setLoose(so.getLoose()).setSubobjectType(so.getSubobjectType()).build()).collect(Collectors.toList()));
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Sero), (String)"Wrong instance of PCEPObject. Passed %s. Needed EroObject.", object.getClass());
        Sero sero = (Sero)object;
        ByteBuf body = Unpooled.buffer();
        List<Subobject> subObjects = sero.nonnullSubobject().stream().map(so -> new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder().setLoose(so.getLoose()).setSubobjectType(so.getSubobjectType()).build()).collect(Collectors.toList());
        this.serializeSubobject(subObjects, body);
        ObjectUtil.formatSubobject((int)1, (int)29, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

