/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcerrBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.PcerrMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcep.error.object.ErrorObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.Errors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.ErrorsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.RequestCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.RequestCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.SessionCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.SessionCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.RequestBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.request.Rps;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.request._case.request.RpsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.pcerr.message.error.type.session._case.SessionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;

public class PCEPErrorMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 6;

    public PCEPErrorMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof PcerrMessage), (String)"Wrong instance of Message. Passed instance of %s. Need PcerrMessage.", (Object)message.getClass());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage err = ((PcerrMessage)message).getPcerrMessage();
        Preconditions.checkArgument((err.getErrors() != null && !err.nonnullErrors().isEmpty() ? 1 : 0) != 0, (Object)"Errors should not be empty.");
        ByteBuf buffer = Unpooled.buffer();
        this.serializeCases(err, buffer);
        for (Errors e : err.nonnullErrors()) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)e.getErrorObject(), buffer);
        }
        if (err.getErrorType() instanceof SessionCase) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)((SessionCase)err.getErrorType()).getSession().getOpen(), buffer);
        }
        MessageUtil.formatMessage((int)6, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected void serializeCases(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcerr.message.PcerrMessage err, ByteBuf buffer) {
        if (err.getErrorType() instanceof RequestCase) {
            for (Rps r : ((RequestCase)err.getErrorType()).getRequest().nonnullRps()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)r.getRp(), buffer);
            }
        }
    }

    protected PcerrMessage validate(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        State initialState;
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Passed list can't be null.");
        ArrayList<Rps> requestParameters = new ArrayList<Rps>();
        ArrayList<Errors> errorObjects = new ArrayList<Errors>();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object first = objects.poll();
        if (first instanceof ErrorObject) {
            errorObjects.add(new ErrorsBuilder().setErrorObject((ErrorObject)first).build());
            initialState = State.ERROR_IN;
        } else if (first instanceof Rp) {
            Rp rp = (Rp)first;
            if (rp.getProcessingRule().booleanValue()) {
                errors.add(PCEPErrorMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.P_FLAG_NOT_SET, Optional.empty()));
                return null;
            }
            requestParameters.add(new RpsBuilder().setRp(rp).build());
            initialState = State.RP_IN;
        } else {
            if (first == null) {
                throw new PCEPDeserializerException("Error message is empty.");
            }
            throw new PCEPDeserializerException("At least one PCEPErrorObject is mandatory.");
        }
        PcerrMessageBuilder msgBuilder = new PcerrMessageBuilder();
        State state = initialState;
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null) {
            if (obj instanceof UnknownObject) {
                return new PcerrBuilder().setPcerrMessage(msgBuilder.setErrors(((UnknownObject)obj).getErrors()).build()).build();
            }
            if ((state = PCEPErrorMessageParser.insertObject(state, errorObjects, obj, requestParameters, msgBuilder)) == State.END) break;
            objects.remove();
            obj = objects.peek();
        }
        if (errorObjects.isEmpty()) {
            throw new PCEPDeserializerException("At least one PCEPErrorObject is mandatory.");
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + String.valueOf(objects));
        }
        if (!requestParameters.isEmpty()) {
            msgBuilder.setErrorType((ErrorType)new RequestCaseBuilder().setRequest(new RequestBuilder().setRps(requestParameters).build()).build());
        }
        return new PcerrBuilder().setPcerrMessage(msgBuilder.setErrors(errorObjects).build()).build();
    }

    private static State insertObject(State state, List<Errors> errorObjects, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, List<Rps> requestParameters, PcerrMessageBuilder msgBuilder) {
        switch (state.ordinal()) {
            case 2: {
                if (obj instanceof Rp) {
                    Rp o = (Rp)obj;
                    requestParameters.add(new RpsBuilder().setRp(o).build());
                    return State.RP_IN;
                }
            }
            case 1: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR_IN;
                }
            }
            case 3: {
                if (obj instanceof Open) {
                    msgBuilder.setErrorType((ErrorType)new SessionCaseBuilder().setSession(new SessionBuilder().setOpen((Open)obj).build()).build());
                    return State.OPEN_IN;
                }
            }
            case 4: {
                if (obj instanceof ErrorObject) {
                    ErrorObject o = (ErrorObject)obj;
                    errorObjects.add(new ErrorsBuilder().setErrorObject(o).build());
                    return State.ERROR;
                }
            }
            case 5: 
            case 6: {
                return State.END;
            }
        }
        return state;
    }

    private static enum State {
        INIT,
        ERROR_IN,
        RP_IN,
        OPEN,
        ERROR,
        OPEN_IN,
        END;

    }
}

