/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.util.Util;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcmonrep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcmonrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.MonitoringMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.GeneralMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.GeneralMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.SpecificMetricsList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.SpecificMetricsListBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.response.monitoring.metrics.list.specific.metrics.list.SpecificMetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcmonrep.message.PcmonrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;

public class PCEPMonitoringReplyMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 9;

    public PCEPMonitoringReplyMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(message instanceof Pcmonrep), (String)"Wrong instance of Message. Passed instance of %s. Need Pcmonrep.", (Object)message.getClass());
        PcmonrepMessage monRepMsg = ((Pcmonrep)message).getPcmonrepMessage();
        Preconditions.checkArgument((monRepMsg.getMonitoring() != null ? 1 : 0) != 0, (Object)"MONITORING object is mandatory.");
        ByteBuf body = Unpooled.buffer();
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)monRepMsg.getMonitoring(), body);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)monRepMsg.getPccIdReq(), body);
        if (monRepMsg.getMonitoringMetricsList() instanceof GeneralMetricsList) {
            GeneralMetricsList gml = (GeneralMetricsList)monRepMsg.getMonitoringMetricsList();
            for (MetricPce metricPce : gml.nonnullMetricPce()) {
                this.serializeMetricPce(metricPce, body);
            }
        } else if (monRepMsg.getMonitoringMetricsList() instanceof SpecificMetricsList) {
            SpecificMetricsList sml = (SpecificMetricsList)monRepMsg.getMonitoringMetricsList();
            for (SpecificMetrics specificMetrics : sml.nonnullSpecificMetrics()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)specificMetrics.getRp(), body);
                for (MetricPce metricPce : specificMetrics.nonnullMetricPce()) {
                    this.serializeMetricPce(metricPce, body);
                }
            }
        }
        MessageUtil.formatMessage((int)9, (ByteBuf)body, (ByteBuf)buffer);
    }

    private void serializeMetricPce(MetricPce metricPce, ByteBuf buffer) {
        Preconditions.checkArgument((metricPce.getPceId() != null ? 1 : 0) != 0, (Object)"PCE-ID must be present.");
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getPceId(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getProcTime(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getOverload(), buffer);
    }

    protected Message validate(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Passed list can't be null.");
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object monitoring = objects.poll();
        if (monitoring == null) {
            throw new PCEPDeserializerException("Pcmonrep message cannot be empty.");
        }
        if (!(monitoring instanceof Monitoring)) {
            errors.add(PCEPMonitoringReplyMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.MONITORING_OBJECT_MISSING, Optional.empty()));
            return null;
        }
        PcmonrepMessageBuilder builder = new PcmonrepMessageBuilder().setMonitoring((Monitoring)monitoring);
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        if (obj instanceof PccIdReq) {
            builder.setPccIdReq((PccIdReq)obj);
            objects.remove();
        }
        PCEPMonitoringReplyMessageParser.validateSpecificMetrics(objects, builder);
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + String.valueOf(objects));
        }
        return new PcmonrepBuilder().setPcmonrepMessage(builder.build()).build();
    }

    private static void validateSpecificMetrics(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, PcmonrepMessageBuilder builder) throws PCEPDeserializerException {
        ArrayList<SpecificMetrics> specificMetrics = new ArrayList<SpecificMetrics>();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null) {
            SpecificMetricsBuilder smb = new SpecificMetricsBuilder();
            if (obj instanceof Rp) {
                smb.setRp((Rp)obj);
                objects.remove();
            }
            ArrayList<MetricPce> metricPceList = new ArrayList<MetricPce>();
            obj = objects.peek();
            while (obj != null && !(obj instanceof Rp)) {
                metricPceList.add(Util.validateMonitoringMetrics(objects));
                obj = objects.peek();
            }
            if (smb.getRp() != null) {
                specificMetrics.add(smb.setMetricPce(metricPceList).build());
            } else if (!metricPceList.isEmpty()) {
                builder.setMonitoringMetricsList((MonitoringMetricsList)new GeneralMetricsListBuilder().setMetricPce(metricPceList).build());
            }
            obj = objects.peek();
        }
        if (!specificMetrics.isEmpty()) {
            builder.setMonitoringMetricsList((MonitoringMetricsList)new SpecificMetricsListBuilder().setSpecificMetrics(specificMetrics).build());
        }
    }
}

