/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.message.PCEPRequestMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcmonreq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcmonreqBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.PcreqMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.MonitoringRequest;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Requests;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcreq.message.pcreq.message.Svec;

public class PCEPMonitoringRequestMessageParser
extends PCEPRequestMessageParser {
    public static final int TYPE = 8;

    public PCEPMonitoringRequestMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    @Override
    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcmonreq), (String)"Wrong instance of Message. Passed instance of %s. Need Pcmonreq.", (java.lang.Object)message.getClass());
        PcreqMessage msg = ((Pcmonreq)message).getPcreqMessage();
        Preconditions.checkArgument((msg.getMonitoringRequest() != null ? 1 : 0) != 0, (java.lang.Object)"MONITORING object MUST be present.");
        ByteBuf buffer = Unpooled.buffer();
        this.serializeMonitoringRequest(msg.getMonitoringRequest(), buffer);
        if (msg.getSvec() != null) {
            this.serializeSvec(msg, buffer);
        }
        if (msg.getRequests() != null) {
            this.serializeRequest(msg, buffer);
        }
        MessageUtil.formatMessage((int)8, (ByteBuf)buffer, (ByteBuf)out);
    }

    @Override
    protected Message validate(Queue<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        List<Requests> requests;
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (java.lang.Object)"Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcmonreq message cannot be empty.");
        }
        MonitoringRequest monReq = this.getMonitoring(objects);
        if (monReq == null) {
            errors.add(PCEPMonitoringRequestMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.MONITORING_OBJECT_MISSING, Optional.empty()));
        }
        PcreqMessageBuilder mBuilder = new PcreqMessageBuilder().setMonitoringRequest(monReq);
        List<Svec> svecs = this.getSvecs(objects);
        if (!svecs.isEmpty()) {
            mBuilder.setSvec(svecs);
        }
        if ((requests = this.getRequests(objects, errors)) != null && !requests.isEmpty()) {
            mBuilder.setRequests(requests);
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + String.valueOf(objects));
        }
        return new PcmonreqBuilder().setPcreqMessage(mBuilder.build()).build();
    }
}

