/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.message.OpenMessageBuilder;

public class PCEPOpenMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 1;

    public PCEPOpenMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenMessage), (String)"Wrong instance of Message. Passed instance of %s. Need OpenMessage.", (java.lang.Object)message.getClass());
        OpenMessage open = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OpenMessage)message).getOpenMessage();
        Preconditions.checkArgument((open.getOpen() != null ? 1 : 0) != 0, (java.lang.Object)"Open Object must be present in Open Message.");
        ByteBuf buffer = Unpooled.buffer();
        this.serializeObject((Object)open.getOpen(), buffer);
        MessageUtil.formatMessage((int)1, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected Open validate(Queue<Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (java.lang.Object)"Passed list can't be null.");
        Object open = objects.poll();
        if (!(open instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open)) {
            throw new PCEPDeserializerException("Open message doesn't contain OPEN object.");
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + String.valueOf(objects));
        }
        return new OpenBuilder().setOpenMessage(new OpenMessageBuilder().setOpen((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open)open).build()).build();
    }
}

