/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.message;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.util.Util;
import org.opendaylight.protocol.pcep.spi.AbstractMessageParser;
import org.opendaylight.protocol.pcep.spi.MessageUtil;
import org.opendaylight.protocol.pcep.spi.ObjectRegistry;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.Pcrep;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.message.rev181109.PcrepBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Message;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.bandwidth.object.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.Ero;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.include.route.object.Iro;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.Metrics;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lsp.attributes.MetricsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.lspa.object.Lspa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.metric.object.Metric;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.object.Monitoring;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcc.id.req.object.PccIdReq;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessage;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.PcrepMessageBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.Replies;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.RepliesBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.Result;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.FailureCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.FailureCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.SuccessCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.SuccessCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.failure._case.NoPath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.SuccessBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.success.Paths;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pcrep.message.pcrep.message.replies.result.success._case.success.PathsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;

public class PCEPReplyMessageParser
extends AbstractMessageParser {
    public static final int TYPE = 4;

    public PCEPReplyMessageParser(ObjectRegistry registry) {
        super(registry);
    }

    public void serializeMessage(Message message, ByteBuf out) {
        Preconditions.checkArgument((boolean)(message instanceof Pcrep), (String)"Wrong instance of Message. Passed instance of %s. Need Pcrep.", (Object)message.getClass());
        PcrepMessage repMsg = ((Pcrep)message).getPcrepMessage();
        List replies = repMsg.nonnullReplies();
        Preconditions.checkArgument((!replies.isEmpty() ? 1 : 0) != 0, (Object)"Replies cannot be null or empty.");
        ByteBuf buffer = Unpooled.buffer();
        for (Replies reply : replies) {
            Preconditions.checkArgument((reply.getRp() != null ? 1 : 0) != 0, (Object)"Reply must contain RP object.");
            this.serializeReply(reply, buffer);
        }
        MessageUtil.formatMessage((int)4, (ByteBuf)buffer, (ByteBuf)out);
    }

    protected void serializeReply(Replies reply, ByteBuf buffer) {
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)reply.getRp(), buffer);
        this.serializeMonitoring(reply, buffer);
        this.serializeVendorInformationObjects(reply.getVendorInformationObject(), buffer);
        if (reply.getResult() == null) {
            return;
        }
        if (reply.getResult() instanceof FailureCase) {
            FailureCase f = (FailureCase)reply.getResult();
            this.serializeFailure(f, buffer);
            return;
        }
        SuccessCase s = (SuccessCase)reply.getResult();
        this.serializeSuccess(s, buffer);
        this.serializeMonitoringMetrics(reply, buffer);
    }

    private void serializeFailure(FailureCase failure, ByteBuf buffer) {
        if (failure == null) {
            return;
        }
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)failure.getNoPath(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)failure.getLspa(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)failure.getBandwidth(), buffer);
        for (Metrics m : failure.nonnullMetrics()) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)m.getMetric(), buffer);
        }
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)failure.getIro(), buffer);
    }

    private void serializeSuccess(SuccessCase success, ByteBuf buffer) {
        if (success == null || success.getSuccess() == null) {
            return;
        }
        for (Paths p : success.getSuccess().nonnullPaths()) {
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p.getEro(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p.getLspa(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p.getOf(), buffer);
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p.getBandwidth(), buffer);
            for (Metrics m : p.nonnullMetrics()) {
                this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)m.getMetric(), buffer);
            }
            this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)p.getIro(), buffer);
        }
        this.serializeVendorInformationObjects(success.getSuccess().getVendorInformationObject(), buffer);
    }

    private void serializeMonitoring(Replies reply, ByteBuf buffer) {
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)reply.getMonitoring(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)reply.getPccIdReq(), buffer);
    }

    private void serializeMonitoringMetrics(Replies reply, ByteBuf buffer) {
        for (MetricPce metricPce : reply.nonnullMetricPce()) {
            this.serializeMetricPce(metricPce, buffer);
        }
    }

    protected void serializeMetricPce(MetricPce metricPce, ByteBuf buffer) {
        Preconditions.checkArgument((metricPce.getPceId() != null ? 1 : 0) != 0, (Object)"PCE-ID must be present.");
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getPceId(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getProcTime(), buffer);
        this.serializeObject((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)metricPce.getOverload(), buffer);
    }

    protected Pcrep validate(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Preconditions.checkArgument((objects != null ? 1 : 0) != 0, (Object)"Passed list can't be null.");
        if (objects.isEmpty()) {
            throw new PCEPDeserializerException("Pcrep message cannot be empty.");
        }
        ArrayList<Replies> replies = new ArrayList<Replies>();
        while (!objects.isEmpty()) {
            Replies r = this.getValidReply(objects, errors);
            if (r == null) continue;
            replies.add(r);
        }
        if (!objects.isEmpty()) {
            throw new PCEPDeserializerException("Unprocessed Objects: " + String.valueOf(objects));
        }
        return new PcrepBuilder().setPcrepMessage(new PcrepMessageBuilder().setReplies(replies).build()).build();
    }

    protected Replies getValidReply(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects, List<Message> errors) throws PCEPDeserializerException {
        Result res;
        List vendorInfo;
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.remove();
        if (!(obj instanceof Rp)) {
            errors.add(PCEPReplyMessageParser.createErrorMsg((PCEPErrors)PCEPErrors.RP_MISSING, Optional.empty()));
            return null;
        }
        RepliesBuilder repliesBuilder = new RepliesBuilder().setRp((Rp)obj);
        obj = objects.peek();
        if (obj instanceof Monitoring) {
            repliesBuilder.setMonitoring((Monitoring)obj);
            objects.remove();
            obj = objects.peek();
        }
        if (obj instanceof PccIdReq) {
            repliesBuilder.setPccIdReq((PccIdReq)obj);
            objects.remove();
        }
        if (!(vendorInfo = PCEPReplyMessageParser.addVendorInformationObjects(objects)).isEmpty()) {
            repliesBuilder.setVendorInformationObject(vendorInfo);
        }
        if ((obj = objects.peek()) instanceof NoPath) {
            objects.remove();
            res = this.handleNoPath((NoPath)obj, objects);
        } else {
            res = obj instanceof Ero ? this.handleEros(objects) : null;
        }
        if (objects.peek() instanceof PceId) {
            ArrayList<MetricPce> metricPceList = new ArrayList<MetricPce>();
            while (!objects.isEmpty()) {
                metricPceList.add(Util.validateMonitoringMetrics(objects));
            }
            if (!metricPceList.isEmpty()) {
                repliesBuilder.setMetricPce(metricPceList);
            }
        }
        return repliesBuilder.setResult(res).build();
    }

    private Result handleNoPath(NoPath noPath, Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        FailureCaseBuilder builder = new FailureCaseBuilder().setNoPath(noPath);
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null && !(obj instanceof PceId)) {
            this.parseAttributes(builder, objects);
            obj = objects.peek();
        }
        return builder.build();
    }

    private Result handleEros(Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        SuccessBuilder builder = new SuccessBuilder();
        ArrayList<Paths> paths = new ArrayList<Paths>();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null && !(obj instanceof PceId)) {
            List vendorInfoObjects;
            PathsBuilder pBuilder = new PathsBuilder();
            if (obj instanceof Ero) {
                pBuilder.setEro((Ero)obj);
                objects.remove();
            }
            if (!(vendorInfoObjects = PCEPReplyMessageParser.addVendorInformationObjects(objects)).isEmpty()) {
                builder.setVendorInformationObject(vendorInfoObjects);
            }
            this.parsePath(pBuilder, objects);
            paths.add(pBuilder.build());
            obj = objects.peek();
        }
        builder.setPaths(paths);
        return new SuccessCaseBuilder().setSuccess(builder.build()).build();
    }

    protected void parseAttributes(FailureCaseBuilder builder, Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        ArrayList<Metrics> pathMetrics = new ArrayList<Metrics>();
        State state = State.INIT;
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null && (state = PCEPReplyMessageParser.insertObject(state, obj, builder, pathMetrics)) != State.END) {
            objects.remove();
            obj = objects.peek();
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static State insertObject(State state, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, FailureCaseBuilder builder, List<Metrics> pathMetrics) {
        switch (state.ordinal()) {
            case 0: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case 1: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case 3: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case 4: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case 5: 
            case 6: {
                return State.END;
            }
        }
        return state;
    }

    private static State insertObject(State state, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj, PathsBuilder builder, List<Metrics> pathMetrics) {
        switch (state.ordinal()) {
            case 0: {
                if (obj instanceof Lspa) {
                    builder.setLspa((Lspa)obj);
                    return State.LSPA_IN;
                }
            }
            case 1: {
                if (obj instanceof Of) {
                    builder.setOf((Of)obj);
                    return State.OF_IN;
                }
            }
            case 2: {
                if (obj instanceof Bandwidth) {
                    builder.setBandwidth((Bandwidth)obj);
                    return State.BANDWIDTH_IN;
                }
            }
            case 3: {
                if (obj instanceof Metric) {
                    pathMetrics.add(new MetricsBuilder().setMetric((Metric)obj).build());
                    return State.BANDWIDTH_IN;
                }
            }
            case 4: {
                if (obj instanceof Iro) {
                    builder.setIro((Iro)obj);
                    return State.IRO_IN;
                }
            }
            case 5: 
            case 6: {
                return State.END;
            }
        }
        return state;
    }

    protected void parsePath(PathsBuilder builder, Queue<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object> objects) {
        ArrayList<Metrics> pathMetrics = new ArrayList<Metrics>();
        State state = State.INIT;
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object obj = objects.peek();
        while (obj != null && (state = PCEPReplyMessageParser.insertObject(state, obj, builder, pathMetrics)) != State.END) {
            objects.remove();
            obj = objects.peek();
        }
        if (!pathMetrics.isEmpty()) {
            builder.setMetrics(pathMetrics);
        }
    }

    private static enum State {
        INIT,
        LSPA_IN,
        OF_IN,
        BANDWIDTH_IN,
        METRIC_IN,
        IRO_IN,
        END;

    }
}

