/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.EnterpriseSpecificInformationParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.iana.rev130816.EnterpriseNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.objects.VendorInformationObjectBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public abstract class AbstractVendorInformationObjectParser
extends CommonObjectParser
implements ObjectSerializer,
EnterpriseSpecificInformationParser {
    public AbstractVendorInformationObjectParser(int objectClass, int objectType) {
        super(objectClass, objectType);
    }

    public final Object parseObject(ObjectHeader header, ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        return new VendorInformationObjectBuilder().setEnterpriseNumber(new EnterpriseNumber(this.getEnterpriseNumber())).setEnterpriseSpecificInformation(this.parseEnterpriseSpecificInformation(buffer)).build();
    }

    public final void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof VendorInformationObject), (String)"Wrong instance of PCEPObject. Passed %s. Needed VendorInformationObject.", (java.lang.Object)object.getClass());
        ByteBuf body = Unpooled.buffer();
        ByteBufUtils.write((ByteBuf)body, (Uint32)this.getEnterpriseNumber().getValue());
        this.serializeEnterpriseSpecificInformation(((VendorInformationObject)object).getEnterpriseSpecificInformation(), body);
        ObjectUtil.formatSubobject((int)1, (int)34, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

