/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ClassType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassTypeBuilder;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PCEPClassTypeObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPClassTypeObjectParser.class);
    private static final int CLASS = 22;
    private static final int TYPE = 1;
    private static final int CT_F_LENGTH = 3;
    private static final int RESERVED = 29;
    private static final int SIZE = 4;

    public PCEPClassTypeObjectParser() {
        super(22, 1);
    }

    public Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Cannot be null or empty.");
        if (!header.getProcessingRule().booleanValue()) {
            LOG.debug("Processed bit not set on CLASS TYPE OBJECT, ignoring it");
            return null;
        }
        if (bytes.readableBytes() != 4) {
            throw new PCEPDeserializerException("Size of byte array doesn't match defined size. Expected: 4; Passed: " + bytes.readableBytes());
        }
        short ct = (short)bytes.readUnsignedInt();
        ClassTypeBuilder builder = new ClassTypeBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setClassType(new ClassType(Uint8.valueOf((short)ct)));
        if (ct < 0 || ct > 8) {
            LOG.debug("Invalid class type {}", (java.lang.Object)ct);
            return new UnknownObject(PCEPErrors.INVALID_CT, (Object)builder.build());
        }
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType), (String)"Wrong instance of PCEPObject. Passed %s. Needed ClassTypeObject.", (java.lang.Object)object.getClass());
        ByteBuf body = Unpooled.buffer((int)4);
        body.writeZero(3);
        ClassType classType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.classtype.object.ClassType)object).getClassType();
        Preconditions.checkArgument((classType != null ? 1 : 0) != 0, (java.lang.Object)"ClassType is mandatory.");
        ByteBufUtils.write((ByteBuf)body, (Uint8)classType.getValue());
        ObjectUtil.formatSubobject((int)1, (int)22, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

