/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.protocol.util.ByteBufWriteUtil;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.ieee754.rev130819.Float32;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.network.concepts.rev131125.Bandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidth;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reoptimization.bandwidth.object.ReoptimizationBandwidthBuilder;

public class PCEPExistingBandwidthObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 5;
    private static final int TYPE = 2;

    public PCEPExistingBandwidthObjectParser() {
        super(5, 2);
    }

    public ReoptimizationBandwidth parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() != 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: 4.");
        }
        ReoptimizationBandwidthBuilder builder = new ReoptimizationBandwidthBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setBandwidth(new Bandwidth(ByteArray.getAllBytes((ByteBuf)bytes)));
        return builder.build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof ReoptimizationBandwidth), (String)"Wrong instance of PCEPObject. Passed %s. Needed ReoptimizationBandwidthObject.", (java.lang.Object)object.getClass());
        ByteBuf body = Unpooled.buffer();
        ByteBufWriteUtil.writeFloat32((Float32)((ReoptimizationBandwidth)object).getBandwidth(), (ByteBuf)body);
        ObjectUtil.formatSubobject((int)2, (int)5, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

