/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.OfId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.Of;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.OfBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.object.of.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPObjectiveFunctionObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 21;
    private static final int TYPE = 1;
    private static final int RESERVED = 2;

    public PCEPObjectiveFunctionObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 21, 1);
    }

    public Of parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        Uint16 ofId = ByteBufUtils.readUint16((ByteBuf)bytes);
        bytes.skipBytes(2);
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        return new OfBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setCode(new OfId(ofId)).setTlvs(tlvsBuilder.build()).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Of), (String)"Wrong instance of PCEPObject. Passed %s. Needed OfObject.", (java.lang.Object)object.getClass());
        Of specObj = (Of)object;
        ByteBuf body = Unpooled.buffer();
        OfId code = specObj.getCode();
        Preconditions.checkArgument((code != null ? 1 : 0) != 0, (java.lang.Object)"Code is mandatory");
        ByteBufUtils.write((ByteBuf)body, (Uint16)code.getValue());
        body.writeZero(2);
        this.serializeTlvs(specObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)21, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

