/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.PCEPErrors;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.UnknownObject;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ProtocolVersion;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.of.list.tlv.OfList;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.Open;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.OpenBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.open.object.open.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PCEPOpenObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(PCEPOpenObjectParser.class);
    private static final int CLASS = 1;
    private static final int TYPE = 1;
    private static final int VERSION_SF_LENGTH = 3;
    private static final int VERSION_SF_OFFSET = 0;
    private static final int PCEP_VERSION = 1;

    public PCEPOpenObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 1, 1);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        byte versionValue = ByteArray.copyBitsRange((byte)bytes.readByte(), (int)0, (int)3);
        short keepalive = bytes.readUnsignedByte();
        short deadTimer = bytes.readUnsignedByte();
        Uint8 sessionId = ByteBufUtils.readUint8((ByteBuf)bytes);
        TlvsBuilder tbuilder = new TlvsBuilder();
        this.parseTlvs(tbuilder, bytes.slice());
        OpenBuilder builder = new OpenBuilder().setVersion(new ProtocolVersion(Uint8.valueOf((int)versionValue))).setProcessingRule(header.getProcessingRule()).setIgnore(header.getIgnore()).setKeepalive(Uint8.valueOf((short)keepalive)).setSessionId(sessionId).setTlvs(tbuilder.build());
        if (keepalive == 0) {
            builder.setDeadTimer(Uint8.ZERO);
        } else {
            builder.setDeadTimer(Uint8.valueOf((short)deadTimer));
        }
        Open obj = builder.build();
        if (versionValue != 1) {
            LOG.debug("Unsupported PCEP version {}", (Object)versionValue);
            return new UnknownObject(PCEPErrors.PCEP_VERSION_NOT_SUPPORTED, (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object)obj);
        }
        return obj;
    }

    public void addTlv(TlvsBuilder tbuilder, Tlv tlv) {
        if (tlv instanceof OfList) {
            tbuilder.setOfList((OfList)tlv);
        }
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Open), (String)"Wrong instance of PCEPObject. Passed %s. Needed OpenObject.", (Object)object.getClass());
        Open open = (Open)object;
        ByteBuf body = Unpooled.buffer();
        body.writeByte(32);
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)open.getKeepalive());
        ByteBufUtils.writeOrZero((ByteBuf)body, (Uint8)open.getDeadTimer());
        ByteBufUtils.writeMandatory((ByteBuf)body, (Uint8)open.getSessionId(), (String)"SessionId");
        this.serializeTlvs(open.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)1, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            if (tlvs.getOfList() != null) {
                this.serializeTlv((Tlv)tlvs.getOfList(), body);
            }
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

