/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.AbstractObjectWithTlvsParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.pcep.spi.TlvRegistry;
import org.opendaylight.protocol.pcep.spi.VendorInformationTlvRegistry;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Tlv;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.order.tlv.Order;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.path.setup.type.tlv.PathSetupType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.Rp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.RpBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.Tlvs;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.rp.object.rp.TlvsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.vendor.information.tlvs.VendorInformationTlv;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.Uint8;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class PCEPRequestParameterObjectParser
extends AbstractObjectWithTlvsParser<TlvsBuilder> {
    private static final int CLASS = 2;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 32;
    private static final int FLAGS_SF_LENGTH = 29;
    private static final int FLAGS_SF_OFFSET = 0;
    private static final int PRI_SF_OFFSET = 29;
    private static final int O_FLAG_OFFSET = 26;
    private static final int B_FLAG_OFFSET = 27;
    private static final int R_FLAG_OFFSET = 28;
    private static final int M_FLAG_OFFSET = 21;
    private static final int D_FLAG_OFFSET = 22;
    private static final int P_FLAG_OFFSET = 23;
    private static final int S_FLAG_OFFSET = 24;
    private static final int F_FLAG_OFFSET = 18;
    private static final int N_FLAG_OFFSET = 19;
    private static final int E_FLAG_OFFSET = 20;

    public PCEPRequestParameterObjectParser(TlvRegistry tlvReg, VendorInformationTlvRegistry viTlvReg) {
        super(tlvReg, viTlvReg, 2, 1);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        BitArray flags = BitArray.valueOf((ByteBuf)bytes, (int)32);
        Uint32 reqId = ByteBufUtils.readUint32((ByteBuf)bytes);
        TlvsBuilder tlvsBuilder = new TlvsBuilder();
        this.parseTlvs(tlvsBuilder, bytes.slice());
        RpBuilder builder = new RpBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setFragmentation(Boolean.valueOf(flags.get(18))).setP2mp(Boolean.valueOf(flags.get(19))).setEroCompression(Boolean.valueOf(flags.get(20))).setMakeBeforeBreak(Boolean.valueOf(flags.get(21))).setOrder(Boolean.valueOf(flags.get(22))).setPathKey(Boolean.valueOf(flags.get(23))).setSupplyOf(Boolean.valueOf(flags.get(24))).setLoose(Boolean.valueOf(flags.get(26))).setBiDirectional(Boolean.valueOf(flags.get(27))).setReoptimization(Boolean.valueOf(flags.get(28))).setRequestId(new RequestId(reqId)).setTlvs(tlvsBuilder.build());
        short priority = 0;
        priority = (short)(priority | (flags.get(31) ? 1 : 0));
        priority = (short)(priority | (flags.get(30) ? 1 : 0) << 1);
        priority = (short)(priority | (flags.get(29) ? 1 : 0) << 2);
        if (priority != 0) {
            builder.setPriority(Uint8.valueOf((short)priority));
        }
        return builder.build();
    }

    public void addTlv(TlvsBuilder builder, Tlv tlv) {
        if (tlv instanceof Order) {
            builder.setOrder((Order)tlv);
        }
        if (tlv instanceof PathSetupType) {
            builder.setPathSetupType((PathSetupType)tlv);
        }
    }

    public void serializeObject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Rp), (String)"Wrong instance of PCEPObject. Passed %s. Needed RPObject.", (Object)object.getClass());
        ByteBuf body = Unpooled.buffer();
        Rp rpObj = (Rp)object;
        BitArray flags = new BitArray(32);
        flags.set(28, rpObj.getReoptimization());
        flags.set(27, rpObj.getBiDirectional());
        flags.set(26, rpObj.getLoose());
        flags.set(21, rpObj.getMakeBeforeBreak());
        flags.set(22, rpObj.getOrder());
        flags.set(23, rpObj.getPathKey());
        flags.set(24, rpObj.getSupplyOf());
        flags.set(18, rpObj.getFragmentation());
        flags.set(19, rpObj.getP2mp());
        flags.set(20, rpObj.getEroCompression());
        byte[] res = flags.array();
        if (rpObj.getPriority() != null) {
            byte p = rpObj.getPriority().byteValue();
            res[res.length - 1] = (byte)(res[res.length - 1] | p);
        }
        body.writeBytes(res);
        RequestId requestId = rpObj.getRequestId();
        Preconditions.checkArgument((requestId != null ? 1 : 0) != 0, (Object)"RequestId is mandatory");
        ByteBufUtils.write((ByteBuf)body, (Uint32)requestId.getValue());
        this.serializeTlvs(rpObj.getTlvs(), body);
        ObjectUtil.formatSubobject((int)1, (int)2, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }

    public void serializeTlvs(Tlvs tlvs, ByteBuf body) {
        if (tlvs != null) {
            if (tlvs.getOrder() != null) {
                this.serializeTlv((Tlv)tlvs.getOrder(), body);
            }
            if (tlvs.getPathSetupType() != null) {
                this.serializeTlv((Tlv)tlvs.getPathSetupType(), body);
            }
            this.serializeVendorInformationTlvs(tlvs.getVendorInformationTlv(), body);
        }
    }

    protected final void addVendorInformationTlvs(TlvsBuilder builder, List<VendorInformationTlv> tlvs) {
        if (!tlvs.isEmpty()) {
            builder.setVendorInformationTlv(tlvs);
        }
    }
}

