/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectSerializer;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.BitArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.RequestId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.Svec;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.svec.object.SvecBuilder;
import org.opendaylight.yangtools.yang.common.Uint32;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public final class PCEPSvecObjectParser
extends CommonObjectParser
implements ObjectSerializer {
    private static final int CLASS = 11;
    private static final int TYPE = 1;
    private static final int FLAGS_SIZE = 24;
    private static final int FLAGS_F_OFFSET = 1;
    private static final int P_FLAG_OFFSET = 19;
    private static final int D_FLAG_OFFSET = 20;
    private static final int S_FLAG_OFFSET = 21;
    private static final int N_FLAG_OFFSET = 22;
    private static final int L_FLAG_OFFSET = 23;
    private static final int MIN_SIZE = 4;

    public PCEPSvecObjectParser() {
        super(11, 1);
    }

    public Svec parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (java.lang.Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() < 4) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + bytes.readableBytes() + "; Expected: >=4.");
        }
        bytes.skipBytes(1);
        BitArray flags = BitArray.valueOf((ByteBuf)bytes, (int)24);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        while (bytes.isReadable()) {
            builder.add((java.lang.Object)new RequestId(ByteBufUtils.readUint32((ByteBuf)bytes)));
        }
        ImmutableSet requestIDs = builder.build();
        if (requestIDs.isEmpty()) {
            throw new PCEPDeserializerException("Empty Svec Object - no request ids.");
        }
        return new SvecBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setLinkDiverse(Boolean.valueOf(flags.get(23))).setNodeDiverse(Boolean.valueOf(flags.get(22))).setSrlgDiverse(Boolean.valueOf(flags.get(21))).setLinkDirectionDiverse(Boolean.valueOf(flags.get(20))).setPartialPathDiverse(Boolean.valueOf(flags.get(19))).setRequestsIds((Set)requestIDs).build();
    }

    public void serializeObject(Object object, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(object instanceof Svec), (String)"Wrong instance of PCEPObject. Passed %s. Needed SvecObject.", (java.lang.Object)object.getClass());
        Svec svecObj = (Svec)object;
        Set requestIDs = svecObj.getRequestsIds();
        Preconditions.checkArgument((!requestIDs.isEmpty() ? 1 : 0) != 0, (java.lang.Object)"Empty Svec Object - no request ids.");
        ByteBuf body = Unpooled.buffer();
        body.writeZero(1);
        BitArray flags = new BitArray(24);
        flags.set(23, svecObj.getLinkDiverse());
        flags.set(22, svecObj.getNodeDiverse());
        flags.set(21, svecObj.getSrlgDiverse());
        flags.set(20, svecObj.getLinkDirectionDiverse());
        flags.set(19, svecObj.getPartialPathDiverse());
        flags.toByteBuf(body);
        for (RequestId requestId : requestIDs) {
            ByteBufUtils.write((ByteBuf)body, (Uint32)requestId.getValue());
        }
        ObjectUtil.formatSubobject((int)1, (int)11, (Boolean)object.getProcessingRule(), (Boolean)object.getIgnore(), (ByteBuf)body, (ByteBuf)buffer);
    }
}

