/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.object.unreach;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Set;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.CommonObjectParser;
import org.opendaylight.protocol.pcep.spi.ObjectUtil;
import org.opendaylight.protocol.util.Ipv6Util;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv6AddressNoZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.ObjectHeader;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObj;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.UnreachDestinationObjBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.Destination;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.unreach.destination.object.unreach.destination.obj.destination.Ipv6DestinationCaseBuilder;

public final class PCEPIpv6UnreachDestinationParser
extends CommonObjectParser {
    private static final int CLASS = 28;
    private static final int TYPE = 2;

    public PCEPIpv6UnreachDestinationParser() {
        super(28, 2);
    }

    public static void serializeObject(Boolean processing, Boolean ignore, Ipv6DestinationCase ipv6Case, ByteBuf buffer) {
        Set dest = ipv6Case.getDestinationIpv6Address();
        Preconditions.checkArgument((dest != null ? 1 : 0) != 0, (Object)"Destinationipv6Address is mandatory.");
        ByteBuf body = Unpooled.buffer((int)(16 * dest.size()));
        dest.forEach(ipv6 -> Ipv6Util.writeIpv6Address((Ipv6AddressNoZone)ipv6, (ByteBuf)body));
        ObjectUtil.formatSubobject((int)2, (int)28, (Boolean)processing, (Boolean)ignore, (ByteBuf)body, (ByteBuf)buffer);
    }

    public UnreachDestinationObj parseObject(ObjectHeader header, ByteBuf bytes) throws PCEPDeserializerException {
        Preconditions.checkArgument((bytes != null && bytes.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        if (bytes.readableBytes() % 16 != 0) {
            throw new PCEPDeserializerException("Wrong length of array of bytes.");
        }
        ImmutableSet.Builder dest = ImmutableSet.builder();
        while (bytes.isReadable()) {
            dest.add((Object)Ipv6Util.addressForByteBuf((ByteBuf)bytes));
        }
        return new UnreachDestinationObjBuilder().setIgnore(header.getIgnore()).setProcessingRule(header.getProcessingRule()).setDestination((Destination)new Ipv6DestinationCaseBuilder().setDestinationIpv6Address((Set)dest.build()).build()).build();
    }
}

