/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.spi.EROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.EROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.EROSubobjectUtil;
import org.opendaylight.protocol.pcep.spi.XROSubobjectRegistry;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.basic.explicit.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.ExrsCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.ExrsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.ExrsBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.exrs.Exrs;

public class EROExplicitExclusionRouteSubobjectParser
implements EROSubobjectParser,
EROSubobjectSerializer {
    public static final int TYPE = 33;
    private static final int HEADER_LENGTH = 2;
    private final XROSubobjectRegistry registry;

    public EROExplicitExclusionRouteSubobjectParser(XROSubobjectRegistry registry) {
        this.registry = registry;
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject parseSubobject(ByteBuf buffer, boolean loose) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        List<Subobject> xros = this.parseSubobject(buffer);
        ArrayList<Exrs> exrss = new ArrayList<Exrs>();
        for (Subobject xro : xros) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.exrs.ExrsBuilder exrsBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.exrs.ExrsBuilder().setAttribute(xro.getAttribute()).setMandatory(xro.getMandatory()).setSubobjectType(xro.getSubobjectType());
            exrss.add(exrsBuilder.build());
        }
        SubobjectBuilder builder = new SubobjectBuilder().setLoose(Boolean.valueOf(loose)).setSubobjectType((SubobjectType)new ExrsCaseBuilder().setExrs(new ExrsBuilder().setExrs(exrss).build()).build());
        return builder.build();
    }

    private List<Subobject> parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Can't be null or empty.");
        ArrayList<Subobject> xros = new ArrayList<Subobject>();
        while (buffer.isReadable()) {
            boolean mandatory = (buffer.getByte(buffer.readerIndex()) & 0x80) != 0;
            int type = buffer.readUnsignedByte() & 0xFF & 0xFFFFFF7F;
            int length = buffer.readUnsignedByte() - 2;
            if (length > buffer.readableBytes()) {
                throw new PCEPDeserializerException("Wrong length specified. Passed: " + length + "; Expected: <= " + buffer.readableBytes());
            }
            xros.add(this.registry.parseSubobject(type, buffer.readSlice(length), mandatory));
        }
        return xros;
    }

    public void serializeSubobject(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.explicit.route.object.ero.Subobject subobject, ByteBuf buffer) {
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof ExrsCase), (String)"Unknown subobject instance. Passed %s. Needed Exrs.", (Object)subobject.getSubobjectType().getClass());
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.explicit.route.subobjects.subobject.type.exrs._case.Exrs exrs = ((ExrsCase)subobject.getSubobjectType()).getExrs();
        ArrayList<Subobject> xros = new ArrayList<Subobject>();
        for (Exrs exr : exrs.nonnullExrs()) {
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder xroBuilder = new org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.exclude.route.object.xro.SubobjectBuilder().setAttribute(exr.getAttribute()).setMandatory(exr.getMandatory()).setSubobjectType(exr.getSubobjectType());
            xros.add(xroBuilder.build());
        }
        ByteBuf body = Unpooled.buffer();
        this.serializeSubobject(xros, body);
        EROSubobjectUtil.formatSubobject((int)33, (Boolean)subobject.getLoose(), (ByteBuf)body, (ByteBuf)buffer);
    }

    private void serializeSubobject(List<Subobject> subobjects, ByteBuf body) {
        for (Subobject subobject : subobjects) {
            this.registry.serializeSubobject(subobject, body);
        }
    }
}

