/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.subobject;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.protocol.pcep.parser.subobject.RROPathKey128SubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectParser;
import org.opendaylight.protocol.pcep.spi.RROSubobjectSerializer;
import org.opendaylight.protocol.pcep.spi.RROSubobjectUtil;
import org.opendaylight.protocol.util.ByteArray;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.Subobject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.reported.route.object.rro.SubobjectBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PathKey;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.SubobjectType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.PathKeyCase;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.PathKeyCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.path.key._case.PathKeyBuilder;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.netty.ByteBufUtils;

public class RROPathKey32SubobjectParser
implements RROSubobjectParser,
RROSubobjectSerializer {
    public static final int TYPE = 64;
    private static final int PK_F_OFFSET = 0;
    private static final int PK_F_LENGTH = 2;
    private static final int PCE_ID_F_LENGTH = 4;
    private static final int PCE_ID_F_OFFSET = 2;
    private static final int CONTENT_LENGTH = 6;

    public Subobject parseSubobject(ByteBuf buffer) throws PCEPDeserializerException {
        Preconditions.checkArgument((buffer != null && buffer.isReadable() ? 1 : 0) != 0, (Object)"Array of bytes is mandatory. Cannot be null or empty.");
        if (buffer.readableBytes() != 6) {
            throw new PCEPDeserializerException("Wrong length of array of bytes. Passed: " + buffer.readableBytes() + "; Expected: >6.");
        }
        return new SubobjectBuilder().setSubobjectType((SubobjectType)new PathKeyCaseBuilder().setPathKey(new PathKeyBuilder().setPathKey(new PathKey(ByteBufUtils.readUint16((ByteBuf)buffer))).setPceId(new PceId(ByteArray.readBytes((ByteBuf)buffer, (int)4))).build()).build()).build();
    }

    public void serializeSubobject(Subobject subobject, ByteBuf buffer) {
        PathKey pathKey;
        Preconditions.checkArgument((boolean)(subobject.getSubobjectType() instanceof PathKeyCase), (String)"Unknown subobject instance. Passed %s. Needed PathKey.", (Object)subobject.getSubobjectType().getClass());
        PathKeyCase pkcase = (PathKeyCase)subobject.getSubobjectType();
        org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.rsvp.rev150820._record.route.subobjects.subobject.type.path.key._case.PathKey pk = pkcase.getPathKey();
        ByteBuf body = Unpooled.buffer();
        PceId pceId = pk.getPceId();
        Preconditions.checkArgument((pceId != null ? 1 : 0) != 0, (Object)"PceId is mandatory.");
        byte[] idBytes = pceId.getValue();
        if (idBytes.length == 16) {
            RROPathKey128SubobjectParser.serializeSubobject(subobject, buffer);
        }
        Preconditions.checkArgument(((pathKey = pk.getPathKey()) != null ? 1 : 0) != 0, (Object)"PathKey is mandatory.");
        ByteBufUtils.write((ByteBuf)body, (Uint16)pathKey.getValue());
        Preconditions.checkArgument((idBytes.length == 4 ? 1 : 0) != 0, (Object)"PceId 32 Bit required.");
        body.writeBytes(idBytes);
        RROSubobjectUtil.formatSubobject((int)64, (ByteBuf)body, (ByteBuf)buffer);
    }
}

