/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.parser.util;

import java.util.Queue;
import org.opendaylight.protocol.pcep.PCEPDeserializerException;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.Object;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPce;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.monitoring.metrics.MetricPceBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.overload.object.Overload;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.pce.id.object.PceId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.types.rev181109.proc.time.object.ProcTime;

public final class Util {
    private Util() {
    }

    private static State insertObject(MetricPceBuilder metricPceBuilder, State state, Object obj) {
        switch (state.ordinal()) {
            case 0: {
                if (obj instanceof ProcTime) {
                    metricPceBuilder.setProcTime((ProcTime)obj);
                    return State.PROC_TIME;
                }
            }
            case 1: {
                if (obj instanceof Overload) {
                    metricPceBuilder.setOverload((Overload)obj);
                    return State.OVERLOAD;
                }
            }
            case 2: 
            case 3: {
                return State.END;
            }
        }
        return state;
    }

    public static MetricPce validateMonitoringMetrics(Queue<Object> objects) throws PCEPDeserializerException {
        Object object = objects.poll();
        if (!(object instanceof PceId)) {
            throw new PCEPDeserializerException("metric-pce-list must start with PCE-ID object.");
        }
        PceId pceId = (PceId)object;
        MetricPceBuilder metricPceBuilder = new MetricPceBuilder().setPceId(pceId);
        State state = State.START;
        Object obj = objects.peek();
        while (obj != null && (state = Util.insertObject(metricPceBuilder, state, obj)) != State.END) {
            objects.remove();
            obj = objects.peek();
        }
        return metricPceBuilder.build();
    }

    private static enum State {
        START,
        PROC_TIME,
        OVERLOAD,
        END;

    }
}

