/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.protocol.pcep.cli.utils;

import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import org.apache.karaf.shell.support.table.ShellTable;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.mdsal.binding.api.DataBroker;
import org.opendaylight.mdsal.binding.api.ReadTransaction;
import org.opendaylight.mdsal.common.api.LogicalDatastoreType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev181109.PcepEntityIdStatsAug;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev181109.StatefulCapabilitiesStatsAug;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stateful.stats.rev181109.StatefulMessagesStatsAug;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Error;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.Preferences;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.error.messages.grouping.ErrorMessages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.LocalPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.Messages;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerCapabilities;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.PeerPref;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.pcep.session.state.grouping.PcepSessionState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.stats.rev171113.reply.time.grouping.ReplyTime;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.topology.pcep.stats.rev181109.PcepTopologyNodeStatsAug;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NetworkTopology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.NodeId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.TopologyId;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.Topology;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.TopologyKey;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.Node;
import org.opendaylight.yang.gen.v1.urn.tbd.params.xml.ns.yang.network.topology.rev131021.network.topology.topology.NodeKey;
import org.opendaylight.yangtools.yang.binding.Identifier;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PcepStateUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PcepStateUtils.class);

    private PcepStateUtils() {
    }

    public static void displayNodeState(@NonNull DataBroker dataBroker, @NonNull PrintStream stream, @NonNull String topologyId, @NonNull String nodeId) {
        Node node = PcepStateUtils.readNodeFromDataStore(dataBroker, topologyId, nodeId);
        if (node == null) {
            stream.println(String.format("Node [%s] not found", nodeId));
            return;
        }
        PcepTopologyNodeStatsAug state = (PcepTopologyNodeStatsAug)node.augmentation(PcepTopologyNodeStatsAug.class);
        if (state == null) {
            stream.println(String.format("State not found for [%s]", nodeId));
            return;
        }
        PcepSessionState nodeState = state.getPcepSessionState();
        PcepStateUtils.displayNodeState(topologyId, nodeId, nodeState, stream);
    }

    private static void displayNodeState(String topologyId, String nodeId, PcepSessionState pcepSessionState, PrintStream stream) {
        ShellTable table = new ShellTable();
        table.column("Attribute").alignLeft();
        table.column("Value").alignLeft();
        PcepStateUtils.showNodeState(table, topologyId, nodeId, pcepSessionState);
        PcepStateUtils.addHeader(table, "Local preferences");
        LocalPref localPref = pcepSessionState.getLocalPref();
        PcepStateUtils.showPreferences(table, (Preferences)localPref);
        PcepEntityIdStatsAug entAug = (PcepEntityIdStatsAug)localPref.augmentation(PcepEntityIdStatsAug.class);
        if (entAug != null) {
            table.addRow().addContent(new Object[]{"Speaker Entity Identifier", Arrays.toString(entAug.getSpeakerEntityIdValue())});
        }
        PcepStateUtils.addHeader(table, "Peer preferences");
        PeerPref peerPref = pcepSessionState.getPeerPref();
        PcepStateUtils.showPreferences(table, (Preferences)peerPref);
        PcepStateUtils.showCapabilities(table, pcepSessionState.getPeerCapabilities());
        Messages messages = pcepSessionState.getMessages();
        PcepStateUtils.showMessages(table, messages);
        ErrorMessages error = messages.getErrorMessages();
        PcepStateUtils.showErrorMessages(table, error);
        ReplyTime reply = messages.getReplyTime();
        PcepStateUtils.showReplyMessages(table, reply);
        table.print(stream, StandardCharsets.UTF_8, true);
    }

    private static void showNodeState(ShellTable table, String topologyId, String nodeId, PcepSessionState pcepSessionState) {
        PcepStateUtils.addHeader(table, "Node state");
        table.addRow().addContent(new Object[]{"Topology Id", topologyId});
        table.addRow().addContent(new Object[]{"Node Id", nodeId});
        table.addRow().addContent(new Object[]{"Session duration", pcepSessionState.getSessionDuration()});
        table.addRow().addContent(new Object[]{"Synchronized", pcepSessionState.getSynchronized()});
        table.addRow().addContent(new Object[]{"Delegated Lsp Count", pcepSessionState.getDelegatedLspsCount()});
    }

    private static void showCapabilities(ShellTable table, PeerCapabilities capa) {
        if (capa == null) {
            return;
        }
        StatefulCapabilitiesStatsAug stateFulCapa = (StatefulCapabilitiesStatsAug)capa.augmentation(StatefulCapabilitiesStatsAug.class);
        if (stateFulCapa != null) {
            PcepStateUtils.addHeader(table, "Stateful Capabilities");
            table.addRow().addContent(new Object[]{"Stateful", stateFulCapa.getStateful()});
            table.addRow().addContent(new Object[]{"Active", stateFulCapa.getActive()});
            table.addRow().addContent(new Object[]{"Instantiation", stateFulCapa.getInstantiation()});
        }
    }

    private static void showMessages(ShellTable table, Messages messages) {
        if (messages == null) {
            return;
        }
        PcepStateUtils.addHeader(table, "Messages");
        table.addRow().addContent(new Object[]{"Last Sent Msg Timestamp", messages.getLastSentMsgTimestamp()});
        table.addRow().addContent(new Object[]{"Received Msg Count", messages.getReceivedMsgCount()});
        table.addRow().addContent(new Object[]{"Sent Msg Count", messages.getSentMsgCount()});
        table.addRow().addContent(new Object[]{"Unknown Msg Received", messages.getUnknownMsgReceived()});
        StatefulMessagesStatsAug statefulMessages = (StatefulMessagesStatsAug)messages.augmentation(StatefulMessagesStatsAug.class);
        if (statefulMessages == null) {
            return;
        }
        PcepStateUtils.addHeader(table, " Stateful Messages");
        table.addRow().addContent(new Object[]{"Last Received RptMsg Timestamp", statefulMessages.getLastReceivedRptMsgTimestamp()});
        table.addRow().addContent(new Object[]{"Received RptMsg", statefulMessages.getReceivedRptMsgCount()});
        table.addRow().addContent(new Object[]{"Sent Init Msg", statefulMessages.getSentInitMsgCount()});
        table.addRow().addContent(new Object[]{"Sent Upd Msg", statefulMessages.getSentUpdMsgCount()});
    }

    private static void showReplyMessages(ShellTable table, ReplyTime reply) {
        if (reply == null) {
            return;
        }
        PcepStateUtils.addHeader(table, "Reply Messages");
        table.addRow().addContent(new Object[]{"Average Time", reply.getAverageTime()});
        table.addRow().addContent(new Object[]{"Max Timet", reply.getMaxTime()});
        table.addRow().addContent(new Object[]{"Min Time", reply.getMinTime()});
    }

    private static void showErrorMessages(ShellTable table, ErrorMessages error) {
        if (error == null) {
            return;
        }
        PcepStateUtils.addHeader(table, "Error Messages");
        table.addRow().addContent(new Object[]{"Sent Error Msg Count", error.getSentErrorMsgCount()});
        table.addRow().addContent(new Object[]{"Received Error Msg Count", error.getReceivedErrorMsgCount()});
        PcepStateUtils.showError(table, (Error)error.getLastSentError(), "Last Sent Error");
        PcepStateUtils.showError(table, (Error)error.getLastReceivedError(), "Last Received Error");
    }

    private static void showError(ShellTable table, Error error, String errorMsgHeader) {
        if (error == null) {
            return;
        }
        PcepStateUtils.addHeader(table, errorMsgHeader);
        table.addRow().addContent(new Object[]{"Type", error.getErrorType()});
        table.addRow().addContent(new Object[]{"Value", error.getErrorValue()});
    }

    private static void showPreferences(ShellTable table, Preferences preferences) {
        table.addRow().addContent(new Object[]{"Session id", preferences.getSessionId()});
        table.addRow().addContent(new Object[]{"Ip Address", preferences.getIpAddress()});
        table.addRow().addContent(new Object[]{"Dead Timer", preferences.getDeadtimer()});
        table.addRow().addContent(new Object[]{"Keep Alive", preferences.getKeepalive()});
    }

    private static Node readNodeFromDataStore(DataBroker dataBroker, String topologyId, String nodeId) {
        InstanceIdentifier topology = InstanceIdentifier.builder(NetworkTopology.class).child(Topology.class, (Identifier)new TopologyKey(new TopologyId(topologyId))).child(Node.class, (Identifier)new NodeKey(new NodeId(nodeId))).build();
        ReadTransaction rot = dataBroker.newReadOnlyTransaction();
        try {
            return ((Optional)rot.read(LogicalDatastoreType.OPERATIONAL, topology).get()).orElse(null);
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn("Failed to read node {}", (Object)nodeId, (Object)e);
            return null;
        }
    }

    private static void addHeader(ShellTable table, String header) {
        table.addRow().addContent(new Object[]{"                      ", ""});
        table.addRow().addContent(new Object[]{header, ""});
        table.addRow().addContent(new Object[]{"======================", ""});
    }
}

