package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration;
import com.google.common.collect.Range;
import java.util.Collections;
import java.util.Map;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import com.google.common.collect.ImmutableList;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yangtools.yang.binding.Augmentation;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02
 */
public class PcepSessionProposalFactoryStateful02Builder {

    private java.lang.Short _deadTimerValue;
    private static List<Range<BigInteger>> _deadTimerValue_range;
    private java.lang.Short _keepAliveTimerValue;
    private static List<Range<BigInteger>> _keepAliveTimerValue_range;
    private java.lang.Integer _timeout;
    private static List<Range<BigInteger>> _timeout_range;
    private java.lang.Boolean _active;
    private java.lang.Boolean _initiated;
    private java.lang.Boolean _stateful;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> augmentation = new HashMap<>();

    public PcepSessionProposalFactoryStateful02Builder() {
    } 
    

    public PcepSessionProposalFactoryStateful02Builder(PcepSessionProposalFactoryStateful02 base) {
        this._deadTimerValue = base.getDeadTimerValue();
        this._keepAliveTimerValue = base.getKeepAliveTimerValue();
        this._timeout = base.getTimeout();
        this._active = base.isActive();
        this._initiated = base.isInitiated();
        this._stateful = base.isStateful();
        if (base instanceof PcepSessionProposalFactoryStateful02Impl) {
            PcepSessionProposalFactoryStateful02Impl _impl = (PcepSessionProposalFactoryStateful02Impl) base;
            this.augmentation = new HashMap<>(_impl.augmentation);
        }
    }


    public java.lang.Short getDeadTimerValue() {
        return _deadTimerValue;
    }
    
    public java.lang.Short getKeepAliveTimerValue() {
        return _keepAliveTimerValue;
    }
    
    public java.lang.Integer getTimeout() {
        return _timeout;
    }
    
    public java.lang.Boolean isActive() {
        return _active;
    }
    
    public java.lang.Boolean isInitiated() {
        return _initiated;
    }
    
    public java.lang.Boolean isStateful() {
        return _stateful;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

    public PcepSessionProposalFactoryStateful02Builder setDeadTimerValue(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _deadTimerValue_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _deadTimerValue_range));
            }
        }
        this._deadTimerValue = value;
        return this;
    }
    public static List<Range<BigInteger>> _deadTimerValue_range() {
        if (_deadTimerValue_range == null) {
            synchronized (PcepSessionProposalFactoryStateful02Builder.class) {
                if (_deadTimerValue_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
                    _deadTimerValue_range = builder.build();
                }
            }
        }
        return _deadTimerValue_range;
    }
    
    public PcepSessionProposalFactoryStateful02Builder setKeepAliveTimerValue(java.lang.Short value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _keepAliveTimerValue_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _keepAliveTimerValue_range));
            }
        }
        this._keepAliveTimerValue = value;
        return this;
    }
    public static List<Range<BigInteger>> _keepAliveTimerValue_range() {
        if (_keepAliveTimerValue_range == null) {
            synchronized (PcepSessionProposalFactoryStateful02Builder.class) {
                if (_keepAliveTimerValue_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(255L)));
                    _keepAliveTimerValue_range = builder.build();
                }
            }
        }
        return _keepAliveTimerValue_range;
    }
    
    public PcepSessionProposalFactoryStateful02Builder setTimeout(java.lang.Integer value) {
        if (value != null) {
            BigInteger _constraint = BigInteger.valueOf(value);
            boolean isValidRange = false;
            for (Range<BigInteger> r : _timeout_range()) {
                if (r.contains(_constraint)) {
                    isValidRange = true;
                }
            }
            if (!isValidRange) {
                throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, _timeout_range));
            }
        }
        this._timeout = value;
        return this;
    }
    public static List<Range<BigInteger>> _timeout_range() {
        if (_timeout_range == null) {
            synchronized (PcepSessionProposalFactoryStateful02Builder.class) {
                if (_timeout_range == null) {
                    ImmutableList.Builder<Range<BigInteger>> builder = ImmutableList.builder();
                    builder.add(Range.closed(BigInteger.ZERO, BigInteger.valueOf(65535L)));
                    _timeout_range = builder.build();
                }
            }
        }
        return _timeout_range;
    }
    
    public PcepSessionProposalFactoryStateful02Builder setActive(java.lang.Boolean value) {
        this._active = value;
        return this;
    }
    
    public PcepSessionProposalFactoryStateful02Builder setInitiated(java.lang.Boolean value) {
        this._initiated = value;
        return this;
    }
    
    public PcepSessionProposalFactoryStateful02Builder setStateful(java.lang.Boolean value) {
        this._stateful = value;
        return this;
    }
    
    public PcepSessionProposalFactoryStateful02Builder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02> augmentation) {
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public PcepSessionProposalFactoryStateful02 build() {
        return new PcepSessionProposalFactoryStateful02Impl(this);
    }

    private static final class PcepSessionProposalFactoryStateful02Impl implements PcepSessionProposalFactoryStateful02 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02.class;
        }

        private final java.lang.Short _deadTimerValue;
        private final java.lang.Short _keepAliveTimerValue;
        private final java.lang.Integer _timeout;
        private final java.lang.Boolean _active;
        private final java.lang.Boolean _initiated;
        private final java.lang.Boolean _stateful;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> augmentation = new HashMap<>();

        private PcepSessionProposalFactoryStateful02Impl(PcepSessionProposalFactoryStateful02Builder base) {
            this._deadTimerValue = base.getDeadTimerValue();
            this._keepAliveTimerValue = base.getKeepAliveTimerValue();
            this._timeout = base.getTimeout();
            this._active = base.isActive();
            this._initiated = base.isInitiated();
            this._stateful = base.isStateful();
                switch (base.augmentation.size()) {
                case 0:
                    this.augmentation = Collections.emptyMap();
                    break;
                    case 1:
                        final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> e = base.augmentation.entrySet().iterator().next();
                        this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>singletonMap(e.getKey(), e.getValue());       
                    break;
                default :
                    this.augmentation = new HashMap<>(base.augmentation);
                }
        }

        @Override
        public java.lang.Short getDeadTimerValue() {
            return _deadTimerValue;
        }
        
        @Override
        public java.lang.Short getKeepAliveTimerValue() {
            return _keepAliveTimerValue;
        }
        
        @Override
        public java.lang.Integer getTimeout() {
            return _timeout;
        }
        
        @Override
        public java.lang.Boolean isActive() {
            return _active;
        }
        
        @Override
        public java.lang.Boolean isInitiated() {
            return _initiated;
        }
        
        @Override
        public java.lang.Boolean isStateful() {
            return _stateful;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_deadTimerValue == null) ? 0 : _deadTimerValue.hashCode());
            result = prime * result + ((_keepAliveTimerValue == null) ? 0 : _keepAliveTimerValue.hashCode());
            result = prime * result + ((_timeout == null) ? 0 : _timeout.hashCode());
            result = prime * result + ((_active == null) ? 0 : _active.hashCode());
            result = prime * result + ((_initiated == null) ? 0 : _initiated.hashCode());
            result = prime * result + ((_stateful == null) ? 0 : _stateful.hashCode());
            result = prime * result + ((augmentation == null) ? 0 : augmentation.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02)obj;
            if (_deadTimerValue == null) {
                if (other.getDeadTimerValue() != null) {
                    return false;
                }
            } else if(!_deadTimerValue.equals(other.getDeadTimerValue())) {
                return false;
            }
            if (_keepAliveTimerValue == null) {
                if (other.getKeepAliveTimerValue() != null) {
                    return false;
                }
            } else if(!_keepAliveTimerValue.equals(other.getKeepAliveTimerValue())) {
                return false;
            }
            if (_timeout == null) {
                if (other.getTimeout() != null) {
                    return false;
                }
            } else if(!_timeout.equals(other.getTimeout())) {
                return false;
            }
            if (_active == null) {
                if (other.isActive() != null) {
                    return false;
                }
            } else if(!_active.equals(other.isActive())) {
                return false;
            }
            if (_initiated == null) {
                if (other.isInitiated() != null) {
                    return false;
                }
            } else if(!_initiated.equals(other.isInitiated())) {
                return false;
            }
            if (_stateful == null) {
                if (other.isStateful() != null) {
                    return false;
                }
            } else if(!_stateful.equals(other.isStateful())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                PcepSessionProposalFactoryStateful02Impl otherImpl = (PcepSessionProposalFactoryStateful02Impl) obj;
                if (augmentation == null) {
                    if (otherImpl.augmentation != null) {
                        return false;
                    }
                } else if(!augmentation.equals(otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.controller.pcep.stateful02.cfg.rev140221.modules.module.configuration.PcepSessionProposalFactoryStateful02>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("PcepSessionProposalFactoryStateful02 [");
            boolean first = true;
        
            if (_deadTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_deadTimerValue=");
                builder.append(_deadTimerValue);
             }
            if (_keepAliveTimerValue != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_keepAliveTimerValue=");
                builder.append(_keepAliveTimerValue);
             }
            if (_timeout != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_timeout=");
                builder.append(_timeout);
             }
            if (_active != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_active=");
                builder.append(_active);
             }
            if (_initiated != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_initiated=");
                builder.append(_initiated);
             }
            if (_stateful != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_stateful=");
                builder.append(_stateful);
             }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
