package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.AdministrativeStatus;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1} instances.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1
 */
public class Link1Builder {

    private AdministrativeStatus _administrativeStatus;
    private java.lang.Boolean _operationalStatus;


    public Link1Builder() {
    } 
    
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.OperAttributes arg) {
        this._operationalStatus = arg.isOperationalStatus();
    }
    
    public Link1Builder(org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.CfgAttributes arg) {
        this._administrativeStatus = arg.getAdministrativeStatus();
    }

    public Link1Builder(Link1 base) {
        this._administrativeStatus = base.getAdministrativeStatus();
        this._operationalStatus = base.isOperationalStatus();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.OperAttributes</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.CfgAttributes</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.OperAttributes) {
            this._operationalStatus = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.OperAttributes)arg).isOperationalStatus();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.CfgAttributes) {
            this._administrativeStatus = ((org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.CfgAttributes)arg).getAdministrativeStatus();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.OperAttributes, org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.CfgAttributes] \n" +
              "but was: " + arg
            );
        }
    }

    public AdministrativeStatus getAdministrativeStatus() {
        return _administrativeStatus;
    }
    
    public java.lang.Boolean isOperationalStatus() {
        return _operationalStatus;
    }

    public Link1Builder setAdministrativeStatus(AdministrativeStatus value) {
        this._administrativeStatus = value;
        return this;
    }
    
    public Link1Builder setOperationalStatus(java.lang.Boolean value) {
        this._operationalStatus = value;
        return this;
    }

    public Link1 build() {
        return new Link1Impl(this);
    }

    private static final class Link1Impl implements Link1 {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1.class;
        }

        private final AdministrativeStatus _administrativeStatus;
        private final java.lang.Boolean _operationalStatus;


        private Link1Impl(Link1Builder base) {
            this._administrativeStatus = base.getAdministrativeStatus();
            this._operationalStatus = base.isOperationalStatus();
        }

        @Override
        public AdministrativeStatus getAdministrativeStatus() {
            return _administrativeStatus;
        }
        
        @Override
        public java.lang.Boolean isOperationalStatus() {
            return _operationalStatus;
        }

        @Override
        public int hashCode() {
            final int prime = 31;
            int result = 1;
            result = prime * result + ((_administrativeStatus == null) ? 0 : _administrativeStatus.hashCode());
            result = prime * result + ((_operationalStatus == null) ? 0 : _operationalStatus.hashCode());
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1 other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.Link1)obj;
            if (_administrativeStatus == null) {
                if (other.getAdministrativeStatus() != null) {
                    return false;
                }
            } else if(!_administrativeStatus.equals(other.getAdministrativeStatus())) {
                return false;
            }
            if (_operationalStatus == null) {
                if (other.isOperationalStatus() != null) {
                    return false;
                }
            } else if(!_operationalStatus.equals(other.isOperationalStatus())) {
                return false;
            }
            return true;
        }
        
        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("Link1 [");
            boolean first = true;
        
            if (_administrativeStatus != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_administrativeStatus=");
                builder.append(_administrativeStatus);
             }
            if (_operationalStatus != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_operationalStatus=");
                builder.append(_operationalStatus);
             }
            return builder.append(']').toString();
        }
    }

}
