package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.rsvp.error.spec.tlv.RsvpErrorSpec;


/**
 * RSVP Error Spec TLV
 * <p>This class represents the following YANG schema fragment defined in module <b>odl-pcep-ietf-stateful02</b>
 * <br />(Source path: <i>META-INF/yang/odl-pcep-ietf-stateful02.yang</i>):
 * <pre>
 * grouping rsvp-error-spec-tlv {
 *     container rsvp-error-spec {
 *         container rsvp-error {
 *             leaf node {
 *                 type ip-address;
 *             }
 *             leaf flags {
 *                 type bits;
 *             }
 *             leaf code {
 *                 type uint8;
 *             }
 *             leaf value {
 *                 type uint16;
 *             }
 *             uses error-spec;
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>odl-pcep-ietf-stateful02/rsvp-error-spec-tlv</i>
 */
public interface RsvpErrorSpecTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:crabbe:stateful:02","2014-01-10","rsvp-error-spec-tlv");;

    RsvpErrorSpec getRsvpErrorSpec();

}

