package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.pcep.crabbe.stateful._02.rev140110.stateful.capability.tlv.Stateful;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.DataObject;


/**
 * Stateful PCE Capability TLV
 * <p>This class represents the following YANG schema fragment defined in module <b>odl-pcep-ietf-stateful02</b>
 * <br />(Source path: <i>META-INF/yang/odl-pcep-ietf-stateful02.yang</i>):
 * <pre>
 * grouping stateful-capability-tlv {
 *     container stateful {
 *         leaf lsp-update-capability {
 *             type boolean;
 *         }
 *         leaf include-db-version {
 *             type boolean;
 *         }
 *         uses tlv;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>odl-pcep-ietf-stateful02/stateful-capability-tlv</i>
 */
public interface StatefulCapabilityTlv
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:params:xml:ns:yang:pcep:crabbe:stateful:02","2014-01-10","stateful-capability-tlv");;

    Stateful getStateful();

}

